/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.BaseElectricItem;
import ic2.core.util.Util;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemScanner
extends BaseElectricItem
implements IBoxable {
    public ItemScanner(Configuration config, InternalName internalName, int t) {
        super(config, internalName);
        this.maxCharge = 10000;
        this.transferLimit = 50;
        this.tier = t;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.tier == 1 && !ElectricItem.manager.use(itemstack, 50, (EntityLivingBase)entityplayer) || this.tier == 2 && !ElectricItem.manager.use(itemstack, 250, (EntityLivingBase)entityplayer)) {
            return itemstack;
        }
        if (IC2.platform.isSimulating()) {
            if (this.tier == 2) {
                int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v), true);
                IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore value in this area is " + value, new Object[0]);
            } else {
                int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v), false);
                IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore density in this area is " + value, new Object[0]);
            }
        } else {
            IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/ODScanner.ogg", true, IC2.audioManager.defaultVolume);
        }
        return itemstack;
    }

    public static int valueOfArea(World worldObj, int x, int y, int z, boolean advancedMode) {
        int totalScore = 0;
        int blocksScanned = 0;
        int range = advancedMode ? 4 : 2;
        for (int blockY = y; blockY > 0; --blockY) {
            for (int blockX = x - range; blockX <= x + range; ++blockX) {
                for (int blockZ = z - range; blockZ <= z + range; ++blockZ) {
                    int blockId = worldObj.func_72798_a(blockX, blockY, blockZ);
                    int metaData = worldObj.func_72805_g(blockX, blockY, blockZ);
                    if (advancedMode) {
                        totalScore += ItemScanner.valueOf(blockId, metaData);
                    } else if (ItemScanner.isValuable(blockId, metaData)) {
                        ++totalScore;
                    }
                    ++blocksScanned;
                }
            }
        }
        return blocksScanned > 0 ? (int)(1000.0 * (double)totalScore / (double)blocksScanned) : 0;
    }

    public static boolean isValuable(int blockId, int metaData) {
        return ItemScanner.valueOf(blockId, metaData) > 0;
    }

    public static int valueOf(int blockId, int metaData) {
        if (IC2.valuableOres.containsKey(blockId)) {
            Map<Integer, Integer> metaMap = IC2.valuableOres.get(blockId);
            if (metaMap.containsKey(Short.MAX_VALUE)) {
                return metaMap.get(Short.MAX_VALUE);
            }
            if (metaMap.containsKey(metaData)) {
                return metaMap.get(metaData);
            }
        }
        return 0;
    }

    public int startLayerScan(ItemStack itemStack) {
        return ElectricItem.manager.use(itemStack, 50, null) ? 3 : 0;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

