/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.IThrowableEntity;
import ic2.api.event.LaserEvent;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.MaterialIC2TNT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class EntityMiningLaser
extends Entity
implements IThrowableEntity {
    public float range = 0.0f;
    public float power = 0.0f;
    public int blockBreaks = 0;
    public boolean explosive = false;
    public static int[] unmineableBlocks = new int[]{Block.field_72081_al.field_71990_ca, Block.field_72089_ap.field_71990_ca, Block.field_71944_C.field_71990_ca, Block.field_71938_D.field_71990_ca, Block.field_71942_A.field_71990_ca, Block.field_71943_B.field_71990_ca, Block.field_71986_z.field_71990_ca, Ic2Items.reinforcedStone.field_77993_c, Ic2Items.reinforcedDoorBlock.field_77993_c};
    public static final double laserSpeed = 1.0;
    public EntityLivingBase owner;
    public boolean headingSet = false;
    public boolean smelt = false;
    private int ticksInAir = 0;

    public EntityMiningLaser(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70129_M = 0.0f;
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, boolean smelt) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
        this.smelt = smelt;
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, double yawDeg, double pitchDeg) {
        this(world, entityliving, range, power, blockBreaks, explosive, yawDeg, pitchDeg, entityliving.field_70163_u + (double)entityliving.func_70047_e() - 0.1);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, double yawDeg, double pitchDeg, double y) {
        super(world);
        this.owner = entityliving;
        this.func_70105_a(0.8f, 0.8f);
        this.field_70129_M = 0.0f;
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double x = entityliving.field_70165_t - Math.cos(yaw) * 0.16;
        double z = entityliving.field_70161_v - Math.sin(yaw) * 0.16;
        double startMotionX = -Math.sin(yaw) * Math.cos(pitch);
        double startMotionY = -Math.sin(pitch);
        double startMotionZ = Math.cos(yaw) * Math.cos(pitch);
        this.func_70107_b(x, y, z);
        this.setLaserHeading(startMotionX, startMotionY, startMotionZ, 1.0);
        this.range = range;
        this.power = power;
        this.blockBreaks = blockBreaks;
        this.explosive = explosive;
    }

    protected void func_70088_a() {
    }

    public void setLaserHeading(double motionX, double motionY, double motionZ, double speed) {
        double currentSpeed = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        this.field_70159_w = motionX / currentSpeed * speed;
        this.field_70181_x = motionY / currentSpeed * speed;
        this.field_70179_y = motionZ / currentSpeed * speed;
        this.field_70126_B = this.field_70177_z = (float)Math.toDegrees(Math.atan2(motionX, motionZ));
        this.field_70127_C = this.field_70125_A = (float)Math.toDegrees(Math.atan2(motionY, MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ))));
        this.headingSet = true;
    }

    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.setLaserHeading(motionX, motionY, motionZ, 1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (IC2.platform.isSimulating() && (this.range < 1.0f || this.power <= 0.0f || this.blockBreaks <= 0)) {
            if (this.explosive) {
                this.explode();
            }
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3 oldPosition = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 newPosition = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72831_a(oldPosition, newPosition, false, true);
        oldPosition = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        newPosition = movingobjectposition != null ? Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c) : Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int l = 0; l < list.size(); ++l) {
            double d1;
            float f4;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(l);
            if (!entity1.func_70067_L() || entity1 == this.owner && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f4 = 0.3f), (double)f4, (double)f4)).func_72327_a(oldPosition, newPosition)) == null || !((d1 = oldPosition.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null && IC2.platform.isSimulating()) {
            if (this.explosive) {
                this.explode();
                this.func_70106_y();
                return;
            }
            if (movingobjectposition.field_72308_g != null) {
                LaserEvent.LaserHitsEntityEvent tEvent = new LaserEvent.LaserHitsEntityEvent(this.field_70170_p, this, this.owner, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, movingobjectposition.field_72308_g);
                MinecraftForge.EVENT_BUS.post((Event)tEvent);
                if (this.takeDataFromEvent(tEvent)) {
                    int damage = (int)this.power;
                    if (damage > 0) {
                        entity.func_70015_d(damage * (this.smelt ? 2 : 1));
                        if (tEvent.hitentity.func_70097_a(new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.owner).func_76349_b(), (float)damage) && this.owner instanceof EntityPlayer && (tEvent.hitentity instanceof EntityDragon && ((EntityDragon)tEvent.hitentity).func_110143_aJ() <= 0.0f || tEvent.hitentity instanceof EntityDragonPart && ((EntityDragonPart)tEvent.hitentity).field_70259_a instanceof EntityDragon && ((EntityLivingBase)((EntityDragonPart)tEvent.hitentity).field_70259_a).func_110143_aJ() <= 0.0f)) {
                            IC2.achievements.issueAchievement((EntityPlayer)this.owner, "killDragonMiningLaser");
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                Block tBlock;
                LaserEvent.LaserHitsBlockEvent tEvent = new LaserEvent.LaserHitsBlockEvent(this.field_70170_p, this, this.owner, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d, movingobjectposition.field_72310_e, 0.9f, true, true);
                MinecraftForge.EVENT_BUS.post((Event)tEvent);
                if (this.takeDataFromEvent(tEvent) && (tBlock = Block.field_71973_m[this.field_70170_p.func_72798_a(tEvent.x, tEvent.y, tEvent.z) & 0xFFF]) != null && tBlock != Block.field_71946_M && tBlock != Block.field_72003_bq && tBlock.field_71990_ca != Ic2Items.reinforcedGlass.field_77993_c) {
                    if (!this.canMine(tBlock.field_71990_ca)) {
                        this.func_70106_y();
                    } else if (IC2.platform.isSimulating()) {
                        float resis = 0.0f;
                        resis = tBlock.getExplosionResistance((Entity)this, this.field_70170_p, tEvent.x, tEvent.y, tEvent.z, this.field_70165_t, this.field_70163_u, this.field_70161_v) + 0.3f;
                        this.power -= resis / 10.0f;
                        if (this.power >= 0.0f) {
                            if (tBlock.field_72018_cp == Material.field_76262_s || tBlock.field_72018_cp == MaterialIC2TNT.instance) {
                                tBlock.func_71867_k(this.field_70170_p, tEvent.x, tEvent.y, tEvent.z, new Explosion(this.field_70170_p, (Entity)this, (double)tEvent.x, (double)tEvent.y, (double)tEvent.z, 1.0f));
                            } else if (this.smelt) {
                                if (tBlock.field_72018_cp == Material.field_76245_d) {
                                    tEvent.dropBlock = false;
                                } else {
                                    for (ItemStack isa : tBlock.getBlockDropped(this.field_70170_p, tEvent.x, tEvent.y, tEvent.z, this.field_70170_p.func_72805_g(tEvent.x, tEvent.y, tEvent.z), 0)) {
                                        ItemStack isb = FurnaceRecipes.func_77602_a().getSmeltingResult(isa);
                                        if (isb == null) continue;
                                        ItemStack is = isb.func_77946_l();
                                        if (is.field_77993_c != tBlock.field_71990_ca && is.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[is.field_77993_c] != null && Block.field_71973_m[is.field_77993_c].field_71990_ca != 0) {
                                            tEvent.removeBlock = false;
                                            tEvent.dropBlock = false;
                                            this.field_70170_p.func_72832_d(tEvent.x, tEvent.y, tEvent.z, is.field_77993_c, is.func_77960_j(), 7);
                                        } else {
                                            tEvent.dropBlock = false;
                                            float var6 = 0.7f;
                                            double var7 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                            double var9 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                            double var11 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                            EntityItem var13 = new EntityItem(this.field_70170_p, (double)tEvent.x + var7, (double)tEvent.y + var9, (double)tEvent.z + var11, is);
                                            var13.field_70293_c = 10;
                                            this.field_70170_p.func_72838_d((Entity)var13);
                                        }
                                        this.power = 0.0f;
                                    }
                                }
                            }
                            if (tEvent.removeBlock) {
                                if (tEvent.dropBlock) {
                                    tBlock.func_71914_a(this.field_70170_p, tEvent.x, tEvent.y, tEvent.z, this.field_70170_p.func_72805_g(tEvent.x, tEvent.y, tEvent.z), tEvent.dropChance, 0);
                                }
                                this.field_70170_p.func_72832_d(tEvent.x, tEvent.y, tEvent.z, 0, 0, 7);
                                if (this.field_70170_p.field_73012_v.nextInt(10) == 0 && tBlock.field_72018_cp.func_76217_h()) {
                                    this.field_70170_p.func_72832_d(tEvent.x, tEvent.y, tEvent.z, Block.field_72067_ar.field_71990_ca, 0, 7);
                                }
                            }
                            --this.blockBreaks;
                        }
                    }
                }
            }
        } else {
            this.power -= 0.5f;
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        this.range = (float)((double)this.range - Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean takeDataFromEvent(LaserEvent aEvent) {
        this.owner = aEvent.owner;
        this.range = aEvent.range;
        this.power = aEvent.power;
        this.blockBreaks = aEvent.blockBreaks;
        this.explosive = aEvent.explosive;
        this.smelt = aEvent.smelt;
        if (aEvent.isCanceled()) {
            this.func_70106_y();
            return false;
        }
        return true;
    }

    public void explode() {
        if (IC2.platform.isSimulating()) {
            LaserEvent.LaserExplodesEvent tEvent = new LaserEvent.LaserExplodesEvent(this.field_70170_p, this, this.owner, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, 5.0f, 0.85f, 0.55f);
            MinecraftForge.EVENT_BUS.post((Event)tEvent);
            if (this.takeDataFromEvent(tEvent)) {
                ExplosionIC2 explosion = new ExplosionIC2(this.field_70170_p, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, tEvent.explosionpower, tEvent.explosiondroprate);
                explosion.doExplosion();
            }
        }
    }

    public boolean canMine(int blockId) {
        for (int i = 0; i < unmineableBlocks.length; ++i) {
            if (blockId != unmineableBlocks[i]) continue;
            return false;
        }
        return true;
    }

    public Entity getThrower() {
        return this.owner;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
    }
}

