/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorNanoSuit
extends ItemArmorElectric {
    public ItemArmorNanoSuit(Configuration config, InternalName internalName, int armorType) {
        super(config, internalName, InternalName.nano, armorType, 1000000, 160, 2);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.manager.getCharge(armor) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @ForgeSubscribe
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.func_77973_b() == this) {
            int fallDamage = (int)event.distance - 3;
            if (fallDamage >= 8) {
                return;
            }
            int energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                event.setCanceled(true);
            }
        }
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                IC2.platform.profilerStartSection("NanoHelmet");
                boolean Nightvision = nbtData.func_74767_n("Nightvision");
                short hubmode = nbtData.func_74765_d("HudMode");
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("Nightvision", Nightvision);
                        if (Nightvision) {
                            IC2.platform.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                        }
                    }
                }
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    hubmode = hubmode == 2 ? (short)0 : (short)(hubmode + 1);
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74777_a("HudMode", hubmode);
                        switch (hubmode) {
                            case 0: {
                                IC2.platform.messagePlayer(player, "HUD disabled.", new Object[0]);
                                break;
                            }
                            case 1: {
                                IC2.platform.messagePlayer(player, "HUD (basic) enabled.", new Object[0]);
                                break;
                            }
                            case 2: {
                                IC2.platform.messagePlayer(player, "HUD (extended) enabled", new Object[0]);
                            }
                        }
                    }
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (Nightvision && ElectricItem.manager.use(itemStack, 1, (EntityLivingBase)player)) {
                    int x = MathHelper.func_76128_c((double)player.field_70165_t);
                    int z = MathHelper.func_76128_c((double)player.field_70161_v);
                    int y = MathHelper.func_76128_c((double)player.field_70163_u);
                    int skylight = player.field_70170_p.func_72957_l(x, y, z);
                    if (skylight > 8) {
                        IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76439_r.field_76415_H);
                        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0, true));
                    } else {
                        IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76440_q.field_76415_H);
                        player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
                    }
                    ret = true;
                }
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 4000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }
}

