/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2FluidContainer;
import ic2.core.util.LiquidUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidCell
extends ItemIC2FluidContainer {
    public ItemFluidCell(Configuration config, InternalName internalName) {
        super(config, internalName, 1000);
    }

    @Override
    public String getTextureFolder() {
        return "cell";
    }

    @Override
    public String getTextureName(int index) {
        switch (index) {
            case 0: {
                return this.func_77658_a();
            }
            case 1: {
                return this.func_77658_a() + ".window";
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    Icon getWindowIcon() {
        return this.textures[1];
    }

    public boolean isRepairable() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)player.func_70047_e();
        if (world.field_72995_K) {
            d1 -= (double)player.getDefaultEyeHeight();
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - 3.141593f));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f)))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return stack;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return stack;
            }
            int blockId = world.func_72798_a(x, y, z);
            if (Block.field_71973_m[blockId] instanceof IFluidBlock) {
                FluidStack fluid;
                int amount;
                IFluidBlock liquid = (IFluidBlock)Block.field_71973_m[blockId];
                if (liquid.canDrain(world, x, y, z) && (amount = LiquidUtil.fillContainerStack(stack, player, fluid = liquid.drain(world, x, y, z, false), true)) == fluid.amount) {
                    LiquidUtil.fillContainerStack(stack, player, fluid, false);
                    liquid.drain(world, x, y, z, true);
                }
            } else if (world.func_72805_g(x, y, z) == 0) {
                int amount;
                FluidStack fluid = null;
                if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
                    fluid = new FluidStack(FluidRegistry.WATER, 1000);
                } else if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
                    fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                }
                if (fluid != null && (amount = LiquidUtil.fillContainerStack(stack, player, fluid, true)) == fluid.amount) {
                    LiquidUtil.fillContainerStack(stack, player, fluid, false);
                    world.func_72832_d(x, y, z, 0, 0, 3);
                }
            }
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        FluidStack fs = this.getFluid(stack);
        if (fs == null || player.func_70093_af() && fs.amount < this.capacity) {
            int amount = fs == null ? this.capacity : this.capacity - fs.amount;
            FluidStack input = handler.drain(dir, amount, false);
            if (input == null || input.amount <= 0) {
                return false;
            }
            amount = LiquidUtil.fillContainerStack(stack, player, input, false);
            if (amount <= 0) {
                return false;
            }
            handler.drain(dir, amount, true);
            return true;
        }
        int amount = handler.fill(dir, fs, false);
        if (amount <= 0) {
            return false;
        }
        fs = LiquidUtil.drainContainerStack(stack, player, amount, false);
        if (fs == null || fs.amount <= 0) {
            return false;
        }
        handler.fill(dir, fs, true);
        return true;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }
}

