/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.Direction;
import ic2.api.energy.IEnergyNet;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.energy.EventHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class EnergyNetGlobal
implements IEnergyNet {
    public static EnergyNetGlobal initialize() {
        return new EnergyNetGlobal();
    }

    private EnergyNetGlobal() {
        new EventHandler();
    }

    @Override
    public TileEntity getTileEntity(World world, int x, int y, int z) {
        return WorldData.get((World)world).energyNet.getTileEntity(x, y, z);
    }

    @Override
    public TileEntity getNeighbor(TileEntity te, ForgeDirection dir) {
        return WorldData.get((World)te.field_70331_k).energyNet.getNeighbor(te, Direction.directions[(dir.ordinal() + 2) % 6]);
    }

    @Override
    public long getTotalEnergyEmitted(TileEntity te) {
        return WorldData.get((World)te.field_70331_k).energyNet.getTotalEnergyEmitted(te);
    }

    @Override
    public long getTotalEnergySunken(TileEntity te) {
        return WorldData.get((World)te.field_70331_k).energyNet.getTotalEnergySunken(te);
    }

    @Override
    public int getPowerFromTier(int tier) {
        return 8 * (4 << tier * 2);
    }

    public static void onTickEnd(World world) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        WorldData.get((World)world).energyNet.onTickEnd();
    }
}

