/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityCableDetector;
import ic2.core.block.wiring.TileEntityCableSplitter;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.util.AabbUtil;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public class BlockCable
extends BlockMultiID {
    private static final Direction[] directions = Direction.values();
    private static final int[] coloredMetas = new int[]{0, 3, 4, 6, 7, 8, 9};
    protected int colorMultiplier = -1;
    public boolean enableBreakBlock = true;
    @SideOnly(value=Side.CLIENT)
    private Icon[][] coloredTextures;

    public BlockCable(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76243_f, ItemBlockIC2.class);
        this.func_71848_c(0.2f);
        this.func_71884_a(field_71975_k);
        this.func_71849_a(null);
        Ic2Items.copperCableBlock = new ItemStack((Block)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new ItemStack((Block)this, 1, 0);
        Ic2Items.goldCableBlock = new ItemStack((Block)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new ItemStack((Block)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new ItemStack((Block)this, 1, 4);
        Ic2Items.ironCableBlock = new ItemStack((Block)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new ItemStack((Block)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.tinCableBlock = new ItemStack((Block)this, 1, 10);
        Ic2Items.detectorCableBlock = new ItemStack((Block)this, 1, 11);
        Ic2Items.splitterCableBlock = new ItemStack((Block)this, 1, 12);
        Ic2Items.insulatedtinCableBlock = new ItemStack((Block)this, 1, 13);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getTextureFolder(int id) {
        return "wiring/cable";
    }

    @Override
    public String getTextureName(int index) {
        ItemStack itemStack;
        Item item = Ic2Items.copperCableItem.func_77973_b();
        String ret = item.func_77667_c(itemStack = new ItemStack((Block)this, 1, index));
        if (ret == null) {
            return null;
        }
        return ret.replace("item", "block");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        super.func_94332_a(iconRegister);
        this.coloredTextures = new Icon[coloredMetas.length][90];
        for (int index = 0; index < coloredMetas.length; ++index) {
            int meta = coloredMetas[index];
            for (int color = 1; color < 16; ++color) {
                String name = "ic2:" + this.getTextureFolder(index) + "/" + this.getTextureName(meta) + "." + Util.getColorName(color).name();
                for (int side = 0; side < 6; ++side) {
                    String subName = name + ":" + side;
                    BlockTextureStitched texture = new BlockTextureStitched(subName, side);
                    this.coloredTextures[index][(color - 1) * 6 + side] = texture;
                    ((TextureMap)iconRegister).setTextureEntry(subName, (TextureAtlasSprite)texture);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntity te = iBlockAccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 0) {
                if (te instanceof TileEntityCableDetector || te instanceof TileEntityCableSplitter || cable.color == 0) {
                    return super.func_71895_b(iBlockAccess, x, y, z, side);
                }
                int index = Arrays.binarySearch(coloredMetas, (int)cable.cableType);
                return this.coloredTextures[index][(cable.color - 1) * 6 + side];
            }
            if (cable.foamed == 1) {
                return Block.field_71973_m[Ic2Items.constructionFoam.field_77993_c].func_71858_a(side, 0);
            }
            Block referencedBlock = cable.getReferencedBlock(side);
            if (referencedBlock != null) {
                try {
                    return referencedBlock.func_71858_a(cable.retextureRefSide[side], cable.retextureRefMeta[side]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return Block.field_71973_m[Ic2Items.constructionFoamWall.field_77993_c].func_71858_a(side, (int)cable.foamColor);
        }
        return null;
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        double halfThickness = tileEntityCable.foamed > 0 ? 0.5 : (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y + 0.5 - halfThickness, (double)z + 0.5 - halfThickness, (double)x + 0.5 + halfThickness, (double)y + 0.5 + halfThickness, (double)z + 0.5 + halfThickness), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        } else if (halfThickness < 0.5) {
            int mask = 1;
            for (Direction dir : directions) {
                if ((tileEntityCable.connectivity & mask) == 0) {
                    mask *= 2;
                    continue;
                }
                mask *= 2;
                AxisAlignedBB bbox = null;
                switch (dir) {
                    case XN: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y + 0.5 - halfThickness, (double)z + 0.5 - halfThickness, (double)x + 0.5, (double)y + 0.5 + halfThickness, (double)z + 0.5 + halfThickness);
                        break;
                    }
                    case XP: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5, (double)y + 0.5 - halfThickness, (double)z + 0.5 - halfThickness, (double)x + 1.0, (double)y + 0.5 + halfThickness, (double)z + 0.5 + halfThickness);
                        break;
                    }
                    case YN: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y, (double)z + 0.5 - halfThickness, (double)x + 0.5 + halfThickness, (double)y + 0.5, (double)z + 0.5 + halfThickness);
                        break;
                    }
                    case YP: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y + 0.5, (double)z + 0.5 - halfThickness, (double)x + 0.5 + halfThickness, (double)y + 1.0, (double)z + 0.5 + halfThickness);
                        break;
                    }
                    case ZN: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y + 0.5 - halfThickness, (double)z, (double)x + 0.5 + halfThickness, (double)y + 0.5, (double)z + 0.5);
                        break;
                    }
                    case ZP: {
                        bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y + 0.5 - halfThickness, (double)z + 0.5, (double)x + 0.5 + halfThickness, (double)y + 0.5 + halfThickness, (double)z + 1.0);
                    }
                }
                intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
                if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
                hit = true;
                break;
            }
        }
        if (hit) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        if (meta == 13) {
            halfThickness = TileEntityCable.getCableThickness(14);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - halfThickness, (double)y + 0.5 - halfThickness, (double)z + 0.5 - halfThickness, (double)x + 0.5 + halfThickness, (double)y + 0.5 + halfThickness, (double)z + 0.5 + halfThickness);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if ((cable.connectivity & 1) != 0) {
            minX = x;
        }
        if ((cable.connectivity & 4) != 0) {
            minY = y;
        }
        if ((cable.connectivity & 0x10) != 0) {
            minZ = z;
        }
        if ((cable.connectivity & 2) != 0) {
            maxX = x + 1;
        }
        if ((cable.connectivity & 8) != 0) {
            maxY = y + 1;
        }
        if ((cable.connectivity & 0x20) != 0) {
            maxZ = z + 1;
        }
        return AxisAlignedBB.func_72332_a().func_72299_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        TileEntity te;
        ItemStack cur = entityPlayer.func_71045_bC();
        if (cur != null && (cur.field_77993_c == Block.field_71939_E.field_71990_ca || cur.field_77993_c == Ic2Items.constructionFoam.field_77993_c) && (te = world.func_72796_p(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cur.field_77993_c == Block.field_71939_E.field_71990_ca && cable.foamed == 1 && cable.changeFoam((byte)2) || cur.field_77993_c == Ic2Items.constructionFoam.field_77993_c && cable.foamed == 0 && cable.changeFoam((byte)1)) {
                if (IC2.platform.isSimulating() && !entityPlayer.field_71075_bZ.field_75098_d) {
                    --cur.field_77994_a;
                    if (cur.field_77994_a <= 0) {
                        entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int srcBlockId) {
        TileEntity te;
        super.func_71863_a(world, x, y, z, srcBlockId);
        if (IC2.platform.isSimulating() && (te = world.func_72796_p(x, y, z)) instanceof TileEntityCable) {
            ((TileEntityCable)te).onNeighborBlockChange();
        }
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                cable.changeFoam((byte)0);
                world.func_72898_h(x, y, z, this.field_71990_ca);
                return false;
            }
        }
        return world.func_72832_d(x, y, z, 0, 0, 3);
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int blockId, int meta) {
        if (this.enableBreakBlock) {
            super.func_71852_a(world, x, y, z, blockId, meta);
        }
    }

    public static int getCableColor(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_72796_p(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int color) {
        color = BlockColored.func_72239_d((int)color);
        return ((TileEntityCable)world.func_72796_p(x, y, z)).changeColor(color);
    }

    @ForgeSubscribe
    public void colorBlock(PaintEvent event) {
        if (event.world.func_72798_a(event.x, event.y, event.z) != this.field_71990_ca) {
            return;
        }
        event.painted = ((TileEntityCable)event.world.func_72796_p(event.x, event.y, event.z)).changeColor(event.color);
    }

    public boolean canHarvestBlock(EntityPlayer player, int md) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.cableType == 14) {
                ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.field_77993_c, 1, 13));
                return ret;
            }
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.field_77993_c, 1, (int)cable.cableType));
        } else {
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.field_77993_c, 1, metadata));
        }
        return ret;
    }

    @Override
    public TileEntityBlock createTileEntity(World world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        if (meta == 13) {
            return new TileEntityCable((short)(meta + 1));
        }
        return new TileEntityCable((short)meta);
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    public int func_71857_b() {
        return IC2.platform.getRenderId("cable");
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71921_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.func_71045_bC(), world, i, j, k);
        }
    }

    public int func_71865_a(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive() ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void func_71879_a(int i, CreativeTabs tabs, List itemList) {
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 1) {
                return 0.01f;
            }
            if (cable.foamed == 2) {
                return 3.0f;
            }
        }
        return 0.2f;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double src_x, double src_y, double src_z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public int getLightOpacity(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 255;
            }
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int direction) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 11 || meta == 12;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ArrayList<ItemStack> ret = this.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
        if (ret.isEmpty()) {
            return null;
        }
        return (ItemStack)ret.get(0);
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (te != null && te.getClass() == TileEntityCableDetector.class) {
            TileEntityCableDetector tec = (TileEntityCableDetector)te;
            return (int)Math.floor((float)EnergyNet.instance.getTotalEnergyEmitted(te) / ((float)tec.getConductorBreakdownEnergy() - 1.0f) * 15.0f);
        }
        return 0;
    }

    @ForgeSubscribe
    public void onRetexture(RetextureEvent event) {
        TileEntity te = event.world.func_72796_p(event.x, event.y, event.z);
        if (te instanceof TileEntityCable && ((TileEntityCable)te).retexture(event.side, event.referencedBlockId, event.referencedMeta, event.referencedSide)) {
            event.applied = true;
        }
    }

    public int func_71920_b(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        if (this.colorMultiplier != -1) {
            return this.colorMultiplier;
        }
        return super.func_71920_b(par1iBlockAccess, x, y, z);
    }
}

