/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.item.ITerraformingBP;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.invslot.InvSlotTfbp;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityTerra
extends TileEntityElectricMachine {
    public int failedAttempts = 0;
    public int lastX = -1;
    public int lastY = -1;
    public int lastZ = -1;
    public AudioSource audioSource;
    public int inactiveTicks = 0;
    public final InvSlotTfbp tfbpSlot = new InvSlotTfbp(this, "tfbp", 0, 1);

    public TileEntityTerra() {
        super(100000, 3, -1);
    }

    @Override
    public String func_70303_b() {
        return "Terraformer";
    }

    @Override
    public void func_70316_g() {
        ITerraformingBP tfbp;
        super.func_70316_g();
        boolean newActive = false;
        if (!this.tfbpSlot.isEmpty() && this.energy >= (double)(tfbp = (ITerraformingBP)this.tfbpSlot.get().func_77973_b()).getConsume()) {
            newActive = true;
            int x = this.field_70329_l;
            int z = this.field_70327_n;
            int range = 1;
            if (this.lastY > -1) {
                range = tfbp.getRange() / 10;
                x = this.lastX - this.field_70331_k.field_73012_v.nextInt(range + 1) + this.field_70331_k.field_73012_v.nextInt(range + 1);
                z = this.lastZ - this.field_70331_k.field_73012_v.nextInt(range + 1) + this.field_70331_k.field_73012_v.nextInt(range + 1);
            } else {
                if (this.failedAttempts > 4) {
                    this.failedAttempts = 4;
                }
                range = tfbp.getRange() * (this.failedAttempts + 1) / 5;
                x = x - this.field_70331_k.field_73012_v.nextInt(range + 1) + this.field_70331_k.field_73012_v.nextInt(range + 1);
                z = z - this.field_70331_k.field_73012_v.nextInt(range + 1) + this.field_70331_k.field_73012_v.nextInt(range + 1);
            }
            if (tfbp.terraform(this.field_70331_k, x, z, this.field_70330_m)) {
                this.energy -= (double)tfbp.getConsume();
                this.failedAttempts = 0;
                this.lastX = x;
                this.lastZ = z;
                this.lastY = this.field_70330_m;
            } else {
                this.energy -= (double)(tfbp.getConsume() / 10);
                ++this.failedAttempts;
                this.lastY = -1;
            }
        }
        if (newActive) {
            this.inactiveTicks = 0;
            this.setActive(true);
        } else if (!newActive && this.getActive() && this.inactiveTicks++ > 30) {
            this.setActive(false);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > 512.0) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean ejectBlueprint() {
        if (this.tfbpSlot.isEmpty()) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            StackUtil.dropAsEntity(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.tfbpSlot.get());
            this.tfbpSlot.clear();
        }
        return true;
    }

    public void insertBlueprint(ItemStack tfbp) {
        this.ejectBlueprint();
        this.tfbpSlot.put(tfbp);
    }

    public static int getFirstSolidBlockFrom(World world, int x, int z, int y) {
        while (y > 0) {
            if (world.func_72804_r(x, y, z)) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static int getFirstBlockFrom(World world, int x, int z, int y) {
        while (y > 0) {
            if (world.func_72798_a(x, y, z) != 0) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static boolean switchGround(World world, Block from, Block to, int x, int y, int z, boolean upwards) {
        int id;
        if (upwards) {
            int id2;
            int saveY = ++y;
            while ((id2 = world.func_72798_a(x, y - 1, z)) != 0 && Block.field_71973_m[id2] == from) {
                --y;
            }
            if (saveY == y) {
                return false;
            }
            world.func_72832_d(x, y, z, to.field_71990_ca, 0, 7);
            return true;
        }
        while ((id = world.func_72798_a(x, y, z)) != 0 && Block.field_71973_m[id] == to) {
            --y;
        }
        id = world.func_72798_a(x, y, z);
        if (id == 0 || Block.field_71973_m[id] != from) {
            return false;
        }
        world.func_72832_d(x, y, z, to.field_71990_ca, 0, 7);
        return true;
    }

    public static BiomeGenBase getBiomeAt(World world, int x, int z) {
        return world.func_72938_d(x, z).func_76591_a(x & 0xF, z & 0xF, world.func_72959_q());
    }

    public static void setBiomeAt(World world, int x, int z, BiomeGenBase biome) {
        Chunk chunk = world.func_72938_d(x, z);
        byte[] array = chunk.func_76605_m();
        array[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.field_76756_M & 0xFF);
        chunk.func_76616_a(array);
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Terraformers/TerraformerGenericloop.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

