/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.Direction;
import ic2.api.item.ItemWrapper;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMetaData;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.AabbUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockPoleFence
extends BlockMetaData {
    private static final double halfThickness = 0.125;
    private static final double halfBarThickness = 0.0625;
    private static final double heightBarBottom = 0.375;
    private static final double heightBar = 0.1875;
    private static final double heightBarDistance = 0.375;
    private static final Direction[] directions = new Direction[]{Direction.XN, Direction.XP, Direction.ZN, Direction.ZP};

    public BlockPoleFence(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76243_f, ItemBlockIC2.class);
        this.func_71848_c(1.5f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71977_i);
        Ic2Items.ironFence = new ItemStack((Block)this);
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public int func_71857_b() {
        return IC2.platform.getRenderId("fence");
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    private AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        double minX = (double)x + 0.5 - 0.125;
        double minY = y;
        double minZ = (double)z + 0.5 - 0.125;
        double maxX = (double)x + 0.5 + 0.125;
        double maxY = selectionBoundingBox ? (double)(y + 1) : (double)y + 1.5;
        double maxZ = (double)z + 0.5 + 0.125;
        if (world.func_72798_a(x - 1, y, z) == this.field_71990_ca) {
            minX = x;
        }
        if (world.func_72798_a(x + 1, y, z) == this.field_71990_ca) {
            maxX = x + 1;
        }
        if (world.func_72798_a(x, y, z - 1) == this.field_71990_ca) {
            minZ = z;
        }
        if (world.func_72798_a(x, y, z + 1) == this.field_71990_ca) {
            maxZ = z + 1;
        }
        return AxisAlignedBB.func_72332_a().func_72299_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.125, (double)y, (double)z + 0.5 - 0.125, (double)x + 0.5 + 0.125, (double)(y + 1), (double)z + 0.5 + 0.125), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        } else {
            block12: for (Direction dir : directions) {
                switch (dir) {
                    case XN: {
                        if (world.func_72798_a(x - 1, y, z) == this.field_71990_ca) break;
                        continue block12;
                    }
                    case XP: {
                        if (world.func_72798_a(x + 1, y, z) == this.field_71990_ca) break;
                        continue block12;
                    }
                    case ZN: {
                        if (world.func_72798_a(x, y, z - 1) == this.field_71990_ca) break;
                        continue block12;
                    }
                    case ZP: {
                        if (world.func_72798_a(x, y, z + 1) == this.field_71990_ca) break;
                        continue block12;
                    }
                    default: {
                        continue block12;
                    }
                }
                block13: for (int pieceToCheck = 0; pieceToCheck < 2; ++pieceToCheck) {
                    AxisAlignedBB bbox = null;
                    double yMin = (double)y + 0.375 + (double)pieceToCheck * 0.375;
                    double yMax = yMin + 0.1875;
                    switch (dir) {
                        case XN: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x, yMin, (double)z + 0.5 - 0.0625, (double)x + 0.5, yMax, (double)z + 0.5 + 0.0625);
                            break;
                        }
                        case XP: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5, yMin, (double)z + 0.5 - 0.0625, (double)x + 1.0, yMax, (double)z + 0.5 + 0.0625);
                            break;
                        }
                        case ZN: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.0625, yMin, (double)z, (double)x + 0.5 + 0.0625, yMax, (double)z + 0.5);
                            break;
                        }
                        case ZP: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.0625, yMin, (double)z + 0.5, (double)x + 0.5 + 0.0625, yMax, (double)z + 1.0);
                            break;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
                    if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
                    hit = true;
                    break;
                }
                if (hit) break;
            }
        }
        if (hit) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public boolean isPole(World world, int i, int j, int k) {
        return world.func_72798_a(i - 1, j, k) != this.field_71990_ca && world.func_72798_a(i + 1, j, k) != this.field_71990_ca && world.func_72798_a(i, j, k - 1) != this.field_71990_ca && world.func_72798_a(i, j, k + 1) != this.field_71990_ca;
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        int id;
        if (this.field_72018_cp != Material.field_76243_f || !this.isPole(world, i, j, k) || !(entity instanceof EntityPlayer)) {
            return;
        }
        boolean powered = world.func_72805_g(i, j, k) > 0;
        boolean metalShoes = false;
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack shoes = player.field_71071_by.field_70460_b[0];
        if (shoes != null && ((id = shoes.field_77993_c) == Item.field_77818_ag.field_77779_bT || id == Item.field_77802_ao.field_77779_bT || id == Item.field_77810_ac.field_77779_bT || ItemWrapper.isMetalArmor(shoes, player))) {
            metalShoes = true;
        }
        if (!powered || !metalShoes) {
            if (player.func_70093_af()) {
                if (player.field_70181_x < -0.25) {
                    player.field_70181_x *= (double)0.9f;
                } else {
                    player.field_70143_R = 0.0f;
                }
            }
        } else {
            world.func_72921_c(i, j, k, world.func_72805_g(i, j, k) - 1, 7);
            player.field_70181_x += (double)0.075f;
            if (player.field_70181_x > 0.0) {
                player.field_70181_x *= (double)1.03f;
                player.field_70143_R = 0.0f;
            }
            if (player.func_70093_af()) {
                if (player.field_70181_x > (double)0.3f) {
                    player.field_70181_x = 0.3f;
                }
            } else if (player.field_70181_x > 1.5) {
                player.field_70181_x = 1.5;
            }
        }
    }
}

