/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ObfuscationManager {
    public static boolean obfuscated = true;

    public static class ClassMapping {
        public String classname;

        public ClassMapping(String classname) {
            this.classname = classname;
        }

        public boolean matches(ClassNode node) {
            return this.classname.equals(node.name);
        }
    }

    public static class FieldMapping {
        public String owner;
        public String name;
        public String type;

        public FieldMapping(String declaringclass, String fieldname, String type) {
            this.owner = declaringclass;
            this.name = fieldname;
            this.type = type;
        }

        public boolean matches(FieldNode node) {
            return this.name.equals(node.name) && this.name.equals(node.desc);
        }

        public FieldInsnNode toInsn(int Opcode) {
            return new FieldInsnNode(Opcode, this.owner.replace('.', '/'), this.name, this.type);
        }
    }

    public static class MethodMapping {
        public String owner;
        public String name;
        public String desc;

        public MethodMapping(String declaringclass, String methodname, String descriptor) {
            this.owner = declaringclass;
            this.name = methodname;
            this.desc = descriptor;
        }

        public MethodMapping(String declaringclass, MethodMapping methodmap) {
            this.owner = declaringclass;
            this.name = methodmap.name;
            this.desc = methodmap.desc;
        }

        public boolean matches(MethodNode node) {
            return this.name.equals(node.name) && this.desc.equals(node.desc);
        }

        public boolean matches(MethodInsnNode node) {
            return this.owner.equals(node.owner) && this.name.equals(node.name) && this.desc.equals(node.desc);
        }

        public MethodInsnNode toInsn(int Opcode) {
            return new MethodInsnNode(Opcode, this.owner.replace('.', '/'), this.name, this.desc);
        }
    }
}

