/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

public class ColourARGB {
    public byte a;
    public byte r;
    public byte g;
    public byte b;

    public ColourARGB(int colourARGB) {
        this.a = (byte)(colourARGB >> 24);
        this.r = (byte)(colourARGB >> 16);
        this.g = (byte)(colourARGB >> 8);
        this.b = (byte)colourARGB;
    }

    public ColourARGB(byte a, byte r, byte g, byte b) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public ColourARGB(ColourARGB colour) {
        this.a = colour.a;
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
    }

    public ColourARGB copy() {
        return new ColourARGB(this);
    }

    public ColourARGB add(ColourARGB colour2) {
        this.a = (byte)(this.a + colour2.a);
        this.r = (byte)(this.r + colour2.r);
        this.g = (byte)(this.g + colour2.g);
        this.b = (byte)(this.b + colour2.b);
        return this;
    }

    public ColourARGB sub(ColourARGB colour2) {
        int ia = (this.a & 0xFF) - (colour2.a & 0xFF);
        int ir = (this.r & 0xFF) - (colour2.r & 0xFF);
        int ig = (this.g & 0xFF) - (colour2.g & 0xFF);
        int ib = (this.b & 0xFF) - (colour2.b & 0xFF);
        this.a = (byte)(ia < 0 ? 0 : ia);
        this.r = (byte)(ir < 0 ? 0 : ir);
        this.g = (byte)(ig < 0 ? 0 : ig);
        this.b = (byte)(ib < 0 ? 0 : ib);
        return this;
    }

    public ColourARGB invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public ColourARGB multiply(ColourARGB colour2) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(colour2.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(colour2.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(colour2.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(colour2.b & 0xFF) / 255.0));
        return this;
    }

    public ColourARGB scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    public ColourARGB interpolate(ColourARGB colour2, double d) {
        return this.add(colour2.copy().sub(this).scale(d));
    }

    public int toInt() {
        return ((this.a & 0xFF) << 24) + ((this.r & 0xFF) << 16) + ((this.g & 0xFF) << 8) + (this.b & 0xFF);
    }

    public String toString() {
        return Integer.toHexString(this.toInt());
    }
}

