/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class TeleportManager {
    public static final TeleportManager instance = new TeleportManager();
    public final List<PipeTeleport> teleportPipes = new LinkedList<PipeTeleport>();
    public final Map<Integer, String> frequencyNames = new HashMap<Integer, String>();

    private TeleportManager() {
    }

    public void add(PipeTeleport pipe) {
        if (!AdditionalPipes.proxy.isServer(pipe.getWorld())) {
            return;
        }
        this.teleportPipes.add(pipe);
        AdditionalPipes.instance.logger.info(String.format("[TeleportManager] Pipe added: %s @ (%d, %d, %d), %d pipes in network", ((Object)((Object)pipe)).getClass().getSimpleName(), pipe.container.field_70329_l, pipe.container.field_70330_m, pipe.container.field_70327_n, this.teleportPipes.size()));
    }

    public void remove(PipeTeleport pipe) {
        if (!AdditionalPipes.proxy.isServer(pipe.getWorld())) {
            return;
        }
        this.teleportPipes.remove((Object)pipe);
        AdditionalPipes.instance.logger.info(String.format("[TeleportManager] Pipe removed: %s @ (%d, %d, %d), %d pipes in network", ((Object)((Object)pipe)).getClass().getSimpleName(), pipe.container.field_70329_l, pipe.container.field_70330_m, pipe.container.field_70327_n, this.teleportPipes.size()));
    }

    public void reset() {
        this.teleportPipes.clear();
        this.frequencyNames.clear();
        AdditionalPipes.instance.logger.info("Reset teleport manager.");
    }

    public List<PipeTeleport> getConnectedPipes(PipeTeleport pipe, boolean forceReceive) {
        LinkedList<PipeTeleport> connected = new LinkedList<PipeTeleport>();
        for (PipeTeleport other : this.teleportPipes) {
            if (!((Object)((Object)pipe)).getClass().equals(((Object)((Object)other)).getClass()) || other.container.func_70320_p() || pipe.container.field_70329_l == other.container.field_70329_l && pipe.container.field_70330_m == other.container.field_70330_m && pipe.container.field_70327_n == other.container.field_70327_n || other.getFrequency() != pipe.getFrequency() || (other.state & 2) <= 0 && !forceReceive || !(pipe.isPublic ? other.isPublic : other.owner.equalsIgnoreCase(pipe.owner))) continue;
            connected.add(other);
        }
        return connected;
    }

    public List<PipeTeleport> getAllPipesInNetwork(PipeTeleport pipe) {
        LinkedList<PipeTeleport> pipes = new LinkedList<PipeTeleport>();
        for (PipeTeleport other : this.teleportPipes) {
            if (!((Object)((Object)pipe)).getClass().equals(((Object)((Object)other)).getClass()) || other.container.func_70320_p() || other.getFrequency() != pipe.getFrequency() || !(pipe.isPublic ? other.isPublic : other.owner.equalsIgnoreCase(pipe.owner))) continue;
            pipes.add(other);
        }
        return pipes;
    }

    public String getFrequencyName(int frequency) {
        String name = this.frequencyNames.get(frequency);
        return name == null ? "" : name;
    }

    public void setFrequencyName(int frequency, String name) {
        this.frequencyNames.put(frequency, name);
    }

    public File getWorldSave(World world) {
        return world.func_72860_G().func_75758_b("foo").getParentFile().getParentFile();
    }
}

