/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.api.core.Position;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class PipeTeleport
extends APPipe {
    protected static final Random rand = new Random();
    private boolean[] phasedBroadcastSignal = new boolean[4];
    private int frequency = 0;
    public byte state = 1;
    public String owner = "";
    public int[] network = new int[0];
    public boolean isPublic = false;

    public PipeTeleport(PipeTransport transport, int itemID) {
        super(transport, itemID);
    }

    public void initialize() {
        super.initialize();
        TeleportManager.instance.add(this);
    }

    public void invalidate() {
        super.invalidate();
        TeleportManager.instance.remove(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        TeleportManager.instance.remove(this);
    }

    public boolean blockActivated(EntityPlayer player) {
        if (!AdditionalPipes.proxy.isServer(player.field_70170_p)) {
            return true;
        }
        if (this.owner == null || "".equalsIgnoreCase(this.owner)) {
            this.owner = player.field_71092_bJ;
        }
        ItemStack equippedItem = player.func_71045_bC();
        player.openGui((Object)AdditionalPipes.instance, 1, this.getWorld(), this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
    }

    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe = null;
        if (tile instanceof TileGenericPipe) {
            pipe = ((TileGenericPipe)tile).pipe;
        }
        if (pipe != null && pipe instanceof PipeTeleport) {
            return false;
        }
        return pipe != null;
    }

    public boolean outputOpen(ForgeDirection to) {
        return this.container.isPipeConnected(to);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("freq", this.frequency);
        nbttagcompound.func_74774_a("state", this.state);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74757_a("isPublic", this.isPublic);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.frequency = nbttagcompound.func_74762_e("freq");
        this.state = nbttagcompound.func_74771_c("state");
        this.owner = nbttagcompound.func_74779_i("owner");
        this.isPublic = nbttagcompound.func_74767_n("isPublic");
    }

    public static boolean canPlayerModifyPipe(EntityPlayer player, PipeTeleport pipe) {
        return pipe.isPublic || pipe.owner.equals(player.field_71092_bJ) || player.field_71075_bZ.field_75098_d;
    }

    public Position getPosition() {
        return new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n);
    }
}

