/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeSwitch
extends APPipe {
    private final int textureIndex;

    public PipeSwitch(PipeTransport transport, int itemID, int textureIndex) {
        super(transport, itemID);
        this.textureIndex = textureIndex;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return this.textureIndex + (this.canPipeConnect(null, direction) ? 0 : 1);
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public void initialize() {
        super.initialize();
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.container.scheduleNeighborChange();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.container.getTile(direction);
            if (!(tile instanceof TileGenericPipe)) continue;
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (this.container == null) {
            return false;
        }
        World world = this.getWorld();
        return world != null && !world.func_72864_z(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
    }
}

