/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.transport.IPipeTransportFluidsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportFluids;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeLiquidsTeleport
extends PipeTeleport
implements IPipeTransportFluidsHook {
    private static final int ICON = 2;

    public PipeLiquidsTeleport(int itemID) {
        super((PipeTransport)new PipeTransportFluids(), itemID);
        ((PipeTransportFluids)this.transport).flowRate = (short)160;
        ((PipeTransportFluids)this.transport).travelDelay = (short)4;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        List<PipeTeleport> pipeList = TeleportManager.instance.getConnectedPipes(this, false);
        if (pipeList.size() == 0 || (this.state & 1) == 0) {
            return 0;
        }
        int i = this.getWorld().field_73012_v.nextInt(pipeList.size());
        List<IFluidHandler> possibleMovements = PipeLiquidsTeleport.getPossibleLiquidMovements(pipeList.get(i));
        if (possibleMovements.size() <= 0) {
            return 0;
        }
        int used = 0;
        while (possibleMovements.size() > 0 && used <= 0) {
            int a = rand.nextInt(possibleMovements.size());
            used = possibleMovements.get(a).fill(ForgeDirection.UNKNOWN, resource, doFill);
            possibleMovements.remove(a);
        }
        return used;
    }

    private static List<IFluidHandler> getPossibleLiquidMovements(PipeTeleport pipe) {
        LinkedList<IFluidHandler> result = new LinkedList<IFluidHandler>();
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            IFluidHandler te;
            if (!pipe.outputOpen(o) || (te = (IFluidHandler)pipe.container.getTile(o)) == null) continue;
            result.add(te);
        }
        return result;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 2;
    }
}

