/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.api.core.Position;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsTeleport
extends PipeTeleport {
    private static final int ICON = 0;
    private final PipeTransportItems transport;

    public PipeItemsTeleport(int itemID) {
        super((PipeTransport)new PipeTransportItems(), itemID);
        this.transport = (PipeTransportItems)((PipeTeleport)this).transport;
    }

    public void eventHandler(PipeEventItem.Entered event) {
        List<PipeTeleport> connectedTeleportPipes = TeleportManager.instance.getConnectedPipes(this, false);
        if (connectedTeleportPipes.size() <= 0 || (this.state & 1) == 0) {
            return;
        }
        LinkedList<ForgeDirection> outputOrientations = new LinkedList<ForgeDirection>();
        PipeTeleport otherPipe = connectedTeleportPipes.get(rand.nextInt(connectedTeleportPipes.size()));
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!otherPipe.outputOpen(o)) continue;
            outputOrientations.add(o);
        }
        if (outputOrientations.size() <= 0) {
            return;
        }
        ForgeDirection newOrientation = (ForgeDirection)outputOrientations.get(rand.nextInt(outputOrientations.size()));
        TileGenericPipe destination = (TileGenericPipe)otherPipe.container.getTile(newOrientation);
        if (destination == null) {
            return;
        }
        Position insertPoint = new Position((double)destination.field_70329_l + 0.5, (double)((float)destination.field_70330_m + TransportUtils.getPipeFloorOf((ItemStack)event.item.getItemStack())), (double)destination.field_70327_n + 0.5, newOrientation.getOpposite());
        insertPoint.moveForwards(0.5);
        event.item.setPosition(insertPoint.x, insertPoint.y, insertPoint.z);
        ((PipeTransportItems)destination.pipe.transport).injectItem(event.item, newOrientation);
        AdditionalPipes.instance.logger.info(event.item + " from " + this.getPosition() + " to " + otherPipe.getPosition() + " " + newOrientation);
        event.cancelled = true;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 0;
    }
}

