/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.core.inventory.TransactorSimple;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsClosed
extends APPipe
implements IInventory,
IItemTravelingHook {
    private ItemStack[] inventory = new ItemStack[10];

    public PipeItemsClosed(int itemID) {
        super((PipeTransport)new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
    }

    public boolean blockActivated(EntityPlayer player) {
        ItemStack equippedItem = player.func_71045_bC();
        if (equippedItem != null && AdditionalPipes.isPipe(equippedItem.func_77973_b())) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 4, this.getWorld(), this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        return true;
    }

    public void dropContents() {
        super.dropContents();
        Utils.preDestroyBlock((World)this.getWorld(), (int)this.container.field_70329_l, (int)this.container.field_70330_m, (int)this.container.field_70327_n);
    }

    public void drop(PipeTransportItems transport, TravelingItem item) {
        TransactorSimple transactor = new TransactorSimple((IInventory)this);
        transactor.add(item.getItemStack().func_77946_l(), ForgeDirection.UNKNOWN, true);
        if (this.inventory[this.inventory.length - 1] != null) {
            for (int i = 1; i < this.inventory.length; ++i) {
                this.inventory[i - 1] = this.inventory[i];
            }
        }
        this.inventory[this.inventory.length - 1] = null;
        item.getItemStack().field_77994_a = 0;
        this.container.scheduleRenderUpdate();
    }

    public void centerReached(PipeTransportItems transport, TravelingItem item) {
    }

    public boolean endReached(PipeTransportItems transport, TravelingItem item, TileEntity tile) {
        return false;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        nbttagcompound.func_74782_a("closedInventory", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList list = nbttagcompound.func_74761_m("closedInventory");
        for (int i = 0; i < list.func_74745_c() && i < this.inventory.length; ++i) {
            NBTTagCompound stackTag = (NBTTagCompound)list.func_74743_b(i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 18 + (this.func_70301_a(0) == null ? 0 : 1);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int amt) {
        ItemStack stack = this.inventory[i].func_77979_a(amt);
        if (this.inventory[i].field_77994_a == 0) {
            this.inventory[i] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack stack = this.inventory[i];
        this.inventory[i] = null;
        return stack;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inventory[i] = stack;
    }

    public String func_70303_b() {
        return "pipeItemsClosed";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

