/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.PipeTransportAdvancedWood;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TravelingItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsAdvancedWood
extends APPipe
implements IPowerReceptor {
    private final PowerHandler powerProvider;
    public final PipeTransportAdvancedWood transport;

    public PipeItemsAdvancedWood(int itemID) {
        super((PipeTransport)new PipeTransportAdvancedWood(), itemID);
        this.transport = (PipeTransportAdvancedWood)((APPipe)this).transport;
        this.powerProvider = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
        this.powerProvider.configure(1.0f, 64.1f, 1.0f, 64.1f);
        this.powerProvider.configurePowerPerdition(0, 0);
    }

    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerProvider.getPowerReceiver();
    }

    public void doWork(PowerHandler workProvider) {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        World w = this.getWorld();
        int meta = w.func_72805_g(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        if (meta > 5) {
            return;
        }
        Position pos = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, ForgeDirection.VALID_DIRECTIONS[meta]);
        pos.moveForwards(1.0);
        int blockId = w.func_72798_a((int)pos.x, (int)pos.y, (int)pos.z);
        TileEntity tile = w.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof IInventory) {
            if (!PipeManager.canExtractItems((Object)((Object)this), (World)w, (int)((int)pos.x), (int)((int)pos.y), (int)((int)pos.z))) {
                return;
            }
            IInventory inventory = (IInventory)tile;
            ItemStack extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
            if (extracted == null || extracted.field_77994_a == 0) {
                this.powerProvider.useEnergy(1.0f, 1.0f, false);
                return;
            }
            Position entityPos = new Position(pos.x + 0.5, pos.y + 0.25, pos.z + 0.5, pos.orientation.getOpposite());
            entityPos.moveForwards(0.5);
            TravelingItem entity = new TravelingItem(entityPos.x, entityPos.y, entityPos.z, extracted);
            this.transport.injectItem(entity, entityPos.orientation);
        }
    }

    public ItemStack checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        IInventory inv = Utils.getInventory((IInventory)inventory);
        int first = 0;
        int last = inv.func_70302_i_() - 1;
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] accessibleSlots = sidedInv.func_94128_d(from.ordinal());
            ItemStack result = this.checkExtractGeneric(inv, doRemove, from, accessibleSlots);
            return result;
        }
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from, first, last);
        return result;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, (int)this.powerProvider.useEnergy(1.0f, (float)slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from, int[] slots) {
        for (int i : slots) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                return inventory.func_70298_a(i, (int)this.powerProvider.useEnergy(1.0f, (float)slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }

    public boolean canExtract(ItemStack item) {
        for (int i = 0; i < this.transport.func_70302_i_(); ++i) {
            ItemStack stack = this.transport.func_70301_a(i);
            if (stack == null || stack.field_77993_c != item.field_77993_c) continue;
            if (Item.field_77698_e[item.field_77993_c].func_77645_m()) {
                return !this.transport.exclude;
            }
            if (stack.func_77960_j() != item.func_77960_j()) continue;
            return !this.transport.exclude;
        }
        return this.transport.exclude;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 6;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return 7;
        }
        return 6;
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n)) {
            this.transport.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
            return true;
        }
        if (AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        entityplayer.openGui((Object)AdditionalPipes.instance, 3, this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        return true;
    }

    public boolean doDrop() {
        Utils.preDestroyBlock((World)this.getWorld(), (int)this.container.field_70329_l, (int)this.container.field_70330_m, (int)this.container.field_70327_n);
        return true;
    }
}

