/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.chunkloader;

import buildcraft.additionalpipes.AdditionalPipes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileChunkLoader
extends TileEntity {
    private ForgeChunkManager.Ticket chunkTicket;
    private int loadDistance = 1;

    public List<ChunkCoordIntPair> getLoadArea() {
        LinkedList<ChunkCoordIntPair> loadArea = new LinkedList<ChunkCoordIntPair>();
        for (int x = -this.loadDistance; x < this.loadDistance + 1; ++x) {
            for (int z = -this.loadDistance; z < this.loadDistance + 1; ++z) {
                ChunkCoordIntPair chunkCoords = new ChunkCoordIntPair((this.field_70329_l >> 4) + x, (this.field_70327_n >> 4) + z);
                loadArea.add(chunkCoords);
            }
        }
        return loadArea;
    }

    public void func_70312_q() {
        ForgeChunkManager.Ticket ticket;
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K && this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)AdditionalPipes.instance, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.forceChunkLoading(ticket);
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.stopChunkLoading();
    }

    public void setLoadDistance(int dist) {
        this.loadDistance = dist;
        this.forceChunkLoading(this.chunkTicket);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.stopChunkLoading();
        this.chunkTicket = ticket;
        for (ChunkCoordIntPair coord : this.getLoadArea()) {
            AdditionalPipes.instance.logger.info(String.format("Force loading chunk %s in %s", coord, this.field_70331_k.field_73011_w.getClass()));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)coord);
        }
    }

    public void unforceChunkLoading() {
        for (Object obj : this.chunkTicket.getChunkList()) {
            ChunkCoordIntPair coord = (ChunkCoordIntPair)obj;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)coord);
        }
    }

    public void stopChunkLoading() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
    }
}

