/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.ChunkLoadViewDataProxy;
import buildcraft.additionalpipes.MutiPlayerProxy;
import buildcraft.additionalpipes.chunkloader.BlockChunkLoader;
import buildcraft.additionalpipes.chunkloader.ChunkLoadingHandler;
import buildcraft.additionalpipes.chunkloader.TileChunkLoader;
import buildcraft.additionalpipes.gates.GateProvider;
import buildcraft.additionalpipes.gates.TriggerPipeClosed;
import buildcraft.additionalpipes.gui.GuiHandler;
import buildcraft.additionalpipes.network.NetworkHandler;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedInsertion;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedWood;
import buildcraft.additionalpipes.pipes.PipeItemsClosed;
import buildcraft.additionalpipes.pipes.PipeItemsDistributor;
import buildcraft.additionalpipes.pipes.PipeItemsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsWaterPump;
import buildcraft.additionalpipes.pipes.PipePowerTeleport;
import buildcraft.additionalpipes.pipes.PipeSwitchFluids;
import buildcraft.additionalpipes.pipes.PipeSwitchItems;
import buildcraft.additionalpipes.pipes.PipeSwitchPower;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.textures.Textures;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.utils.Localization;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(modid="APUnofficial", name="Additional Pipes", dependencies="after:BuildCraft|Transport;after:BuildCraft|Silicon;after:BuildCraft|Transport;after:BuildCraft|Factory", version="@AP_VERSION@")
@NetworkMod(channels={"APUnofficial", "APUnofficialNBT"}, clientSideRequired=true, serverSideRequired=true, packetHandler=NetworkHandler.class)
public class AdditionalPipes {
    public static final String MODID = "APUnofficial";
    public static final String NAME = "Additional Pipes";
    public static final String VERSION = "@AP_VERSION@";
    public static final String CHANNEL = "APUnofficial";
    public static final String CHANNELNBT = "APUnofficialNBT";
    @Mod.Instance(value="APUnofficial")
    public static AdditionalPipes instance;
    @SidedProxy(clientSide="buildcraft.additionalpipes.MutiPlayerProxyClient", serverSide="buildcraft.additionalpipes.MutiPlayerProxy")
    public static MutiPlayerProxy proxy;
    public File configFile;
    public Logger logger;
    public static final String LOC_PATH = "/buildcraft/additionalpipes";
    public static final String[] LOCALIZATIONS;
    public ChunkLoadViewDataProxy chunkLoadViewer;
    @CfgBool
    public boolean chunkSight = true;
    public int chunkSightRange = 8;
    @CfgBool
    public boolean chunkSightAutorefresh = true;
    public Item pipeLiquidsRedstone;
    @CfgId
    public int pipeLiquidsRedstoneId = 14042;
    public Item pipeItemsRedStone;
    @CfgId
    public int pipeItemsRedStoneId = 14043;
    public Item pipeItemsAdvancedInsertion;
    @CfgId
    public int pipeItemsAdvancedInsertionId = 14044;
    public Item pipeItemsAdvancedWood;
    @CfgId
    public int pipeItemsAdvancedWoodId = 14045;
    public Item pipeItemsDistributor;
    @CfgId
    public int pipeItemsDistributorId = 14046;
    public Item pipeItemsTeleport;
    @CfgId
    public int pipeItemsTeleportId = 14047;
    public Item pipeLiquidsTeleport;
    @CfgId
    public int pipeLiquidsTeleportId = 14048;
    public Item pipePowerTeleport;
    @CfgId
    public int pipePowerTeleportId = 14049;
    public Item pipeItemsClosed;
    @CfgId
    public int pipeItemsClosedId = 14050;
    public Item pipePowerSwitch;
    @CfgId
    public int pipePowerSwitchId = 14051;
    public Item pipeItemsSwitch;
    @CfgId
    public int pipeItemsSwitchId = 14052;
    public Item pipeLiquidsSwitch;
    @CfgId
    public int pipeLiquidsSwitchId = 14053;
    public Item pipeLiquidsWaterPump;
    @CfgId
    public int pipeLiquidsWaterPumpId = 14054;
    public Block blockChunkLoader;
    @CfgId(block=true)
    public int chunkLoaderId = 1890;
    @CfgBool
    public boolean enableTriggers = true;
    public ITrigger triggerPipeClosed;
    public ITrigger triggerPhasedSignalRed;
    public ITrigger triggerPhasedSignalBlue;
    public ITrigger triggerPhasedSignalGreen;
    public ITrigger triggerPhasedSignalYellow;
    public int laserKeyCode = 64;
    @CfgBool
    public boolean allowWRRemove = false;
    public float powerLossCfg = 0.9f;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = Logger.getLogger("APUnofficial");
        this.logger.setParent(FMLLog.getLogger());
        this.logger.setLevel(Level.WARNING);
        this.configFile = event.getSuggestedConfigurationFile();
        this.loadConfigs(false);
        for (String lang : LOCALIZATIONS) {
            try {
                Localization.addLocalization((String)"/buildcraft/additionalpipes/lang/", (String)lang);
                Properties localization = new Properties();
                localization.load(AdditionalPipes.class.getResourceAsStream("/buildcraft/additionalpipes/lang/" + lang + ".properties"));
                LanguageRegistry.instance().addStringLocalization(localization);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load localization.", e);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingHandler());
        this.chunkLoadViewer = new ChunkLoadViewDataProxy(this.chunkSightRange);
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)this.chunkLoadViewer, (Side)Side.CLIENT);
        proxy.registerKeyHandler();
        proxy.registerRendering();
        this.loadConfigs(true);
        this.loadPipes();
        this.triggerPipeClosed = new TriggerPipeClosed(212, "APClosed");
        ActionManager.registerTriggerProvider((ITriggerProvider)new GateProvider());
        if (this.allowWRRemove) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipePowerTeleport});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipeLiquidsTeleport});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeItemsRedStone), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipeLiquidsRedstone});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsCobblestone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeFluidsCobblestone});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeFluidsGold});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsIron), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeFluidsIron});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeFluidsStone});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeFluidsWood});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerGold});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerStone});
            GameRegistry.addRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerWood});
        }
        if (this.chunkLoaderId != 0) {
            this.blockChunkLoader = new BlockChunkLoader(this.chunkLoaderId > 0 ? this.chunkLoaderId : -this.chunkLoaderId, 32);
            this.blockChunkLoader.func_71864_b("TeleportTether");
            GameRegistry.registerBlock((Block)this.blockChunkLoader, ItemBlock.class, (String)"chunkLoader");
            GameRegistry.registerTileEntity(TileChunkLoader.class, (String)"TeleportTether");
            if (this.chunkLoaderId > 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(this.blockChunkLoader), (Object[])new Object[]{"iii", "iLi", "iii", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4)});
            }
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        TeleportManager.instance.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigs(boolean postInit) {
        if (!this.configFile.exists() && !postInit || this.configFile.exists() && postInit) {
            return;
        }
        Configuration config = new Configuration(this.configFile);
        try {
            Field[] fields;
            config.load();
            config.addCustomCategoryComment("block", "Set id to 0 to disable loading the block, add - in front of id to disable recipe only.");
            config.addCustomCategoryComment("item", "Set id to 0 to disable loading the item, add - in front of id to disable recipe only.");
            config.addCustomCategoryComment("general", "Disabling items/blocks only disables recipes.");
            for (Field field : fields = AdditionalPipes.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                CfgId annotation = field.getAnnotation(CfgId.class);
                if (annotation != null) {
                    int id = field.getInt(this);
                    if (annotation.block()) {
                        if (config.getCategory("block").containsKey(field.getName())) {
                            id = config.get("block", field.getName(), id).getInt(id);
                            if (id > 0) {
                                id = config.getBlock(field.getName(), id).getInt(id);
                            }
                        } else {
                            id = config.getBlock(field.getName(), id).getInt(id);
                        }
                    } else if (config.getCategory("item").containsKey(field.getName())) {
                        id = config.get("item", field.getName(), id).getInt(id);
                        if (id > 0) {
                            id = config.getItem(field.getName(), id).getInt(id);
                        }
                    } else {
                        id = config.getItem(field.getName(), id).getInt(id);
                    }
                    field.setInt(this, id);
                    continue;
                }
                if (!field.isAnnotationPresent(CfgBool.class)) continue;
                boolean bool = field.getBoolean(this);
                bool = config.get("general", field.getName(), bool).getBoolean(bool);
                field.setBoolean(this, bool);
            }
            Property powerLoss = config.get("general", "powerLoss", (int)(this.powerLossCfg * 100.0f));
            powerLoss.comment = "Percentage of power a power teleport pipe transmits. Between 0 and 100.";
            this.powerLossCfg = (float)powerLoss.getInt() / 100.0f;
            if ((double)this.powerLossCfg > 1.0) {
                this.powerLossCfg = 0.99f;
            } else if ((double)this.powerLossCfg < 0.0) {
                this.powerLossCfg = 0.0f;
            }
            Property chunkLoadSightRange = config.get("general", "chunkSightRange", this.chunkSightRange);
            chunkLoadSightRange.comment = "Range of chunk load boundaries.";
            Property laserKey = config.get("general", "laserKeyChar", this.laserKeyCode);
            laserKey.comment = "Default key to toggle chunk load boundaries.";
            this.laserKeyCode = laserKey.getInt();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error loading Additional Pipes configs.", e);
        }
        finally {
            config.save();
        }
    }

    private void loadPipes() {
        if (this.pipeItemsTeleportId != 0) {
            this.pipeItemsTeleport = this.createPipeSpecial(this.pipeItemsTeleportId > 0 ? this.pipeItemsTeleportId : -this.pipeItemsTeleportId, PipeItemsTeleport.class);
            if (this.pipeItemsTeleportId > 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport, 4), (Object[])new Object[]{"dgd", Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('g'), Block.field_71946_M});
                AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 4), new ItemStack(BuildCraftTransport.pipeItemsDiamond, 8), new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 3)}, 1000, new ItemStack(this.pipeItemsTeleport, 8)));
            }
        }
        if (this.pipeLiquidsTeleportId != 0) {
            this.pipeLiquidsTeleport = this.createPipeSpecial(this.pipeLiquidsTeleportId > 0 ? this.pipeLiquidsTeleportId : -this.pipeLiquidsTeleportId, PipeLiquidsTeleport.class);
            if (this.pipeItemsTeleport != null && this.pipeLiquidsTeleportId > 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeLiquidsTeleport), (Object[])new Object[]{"w", "P", Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('P'), this.pipeItemsTeleport});
            }
        }
        if (this.pipePowerTeleportId != 0) {
            this.pipePowerTeleport = this.createPipeSpecial(this.pipePowerTeleportId > 0 ? this.pipePowerTeleportId : -this.pipePowerTeleportId, PipePowerTeleport.class);
            if (this.pipeItemsTeleport != null && this.pipePowerTeleportId > 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipePowerTeleport), (Object[])new Object[]{"r", "P", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('P'), this.pipeItemsTeleport});
            }
        }
        this.pipeItemsDistributor = this.doCreatePipeAndRecipe(this.pipeItemsDistributorId, PipeItemsDistributor.class, new Object[]{" r ", "IgI", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('g'), Block.field_71946_M});
        this.pipeItemsAdvancedWood = this.doCreatePipeAndRecipe(this.pipeItemsAdvancedWoodId, 8, PipeItemsAdvancedWood.class, new Object[]{"WgW", Character.valueOf('W'), BuildCraftCore.woodenGearItem, Character.valueOf('g'), Block.field_71946_M});
        this.pipeItemsAdvancedInsertion = this.doCreatePipeAndRecipe(this.pipeItemsAdvancedInsertionId, 8, PipeItemsAdvancedInsertion.class, new Object[]{"IgI", Character.valueOf('I'), BuildCraftCore.ironGearItem, Character.valueOf('g'), Block.field_71946_M});
        this.pipeItemsClosed = this.doCreatePipeAndRecipe(this.pipeItemsClosedId, PipeItemsClosed.class, new Object[]{"r", "I", Character.valueOf('I'), BuildCraftTransport.pipeItemsVoid, Character.valueOf('i'), BuildCraftCore.ironGearItem});
        this.pipeItemsSwitch = this.doCreatePipeAndRecipe(this.pipeItemsSwitchId, 8, PipeSwitchItems.class, new Object[]{"GgG", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.goldGearItem});
        this.pipePowerSwitch = this.doCreatePipeAndRecipe(this.pipePowerSwitchId, PipeSwitchPower.class, new Object[]{"r", "I", Character.valueOf('I'), this.pipeItemsSwitch, Character.valueOf('r'), Item.field_77767_aC});
        this.pipeLiquidsSwitch = this.doCreatePipeAndRecipe(this.pipeLiquidsSwitchId, PipeSwitchFluids.class, new Object[]{"w", "I", Character.valueOf('I'), this.pipeItemsSwitch, Character.valueOf('w'), BuildCraftTransport.pipeWaterproof});
        this.pipeLiquidsWaterPump = this.doCreatePipeAndRecipe(this.pipeLiquidsWaterPumpId, PipeLiquidsWaterPump.class, new Object[]{" L ", "rPr", " W ", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('P'), BuildCraftCore.ironGearItem, Character.valueOf('L'), BuildCraftTransport.pipeFluidsGold, Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('W'), BuildCraftTransport.pipeFluidsWood});
    }

    private Item doCreatePipeAndRecipe(int id, Class<? extends Pipe> clas, Object[] recipe) {
        return this.doCreatePipeAndRecipe(id, 1, clas, recipe);
    }

    private Item doCreatePipeAndRecipe(int id, int output, Class<? extends Pipe> clas, Object[] recipe) {
        if (id == 0) {
            return null;
        }
        Item pipe = AdditionalPipes.createPipe(id > 0 ? id : -id, clas);
        for (Object obj : recipe) {
            if (obj != null) continue;
            return pipe;
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(pipe, output), (Object[])recipe);
        return pipe;
    }

    private static Item createPipe(int id, Class<? extends Pipe> clas) {
        ItemPipe res = BlockGenericPipe.registerPipe((int)id, clas);
        res.func_77655_b(clas.getSimpleName());
        proxy.registerPipeRendering((Item)res);
        return res;
    }

    private Item createPipeSpecial(int id, Class<? extends Pipe> clas) {
        ItemPipeAP item = new ItemPipeAP(id);
        item.func_77655_b(clas.getSimpleName());
        proxy.registerPipeRendering((Item)item);
        BlockGenericPipe.pipes.put(item.field_77779_bT, clas);
        proxy.createPipeSpecial(item, id, clas);
        return item;
    }

    public static boolean isPipe(Item item) {
        return item != null && BlockGenericPipe.pipes.containsKey(item.field_77779_bT);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) throws IOException {
        Textures.registerIcons((IconRegister)event.map, event.map.field_94255_a);
    }

    static {
        LOCALIZATIONS = new String[]{"es_ES", "ru_RU", "de_DE", "en_US"};
    }

    private static class ItemPipeAP
    extends ItemPipe {
        protected ItemPipeAP(int i) {
            super(i);
        }

        @SideOnly(value=Side.CLIENT)
        public EnumRarity func_77613_e(ItemStack stack) {
            return EnumRarity.rare;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
            super.func_77624_a(stack, player, list, advanced);
            String key = "tip." + stack.func_77973_b().getClass().getSimpleName();
            if (Localization.hasKey((String)key)) {
                list.add(Localization.get((String)key));
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CfgBool {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CfgId {
        public boolean block() default false;
    }
}

