/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.common;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import ic2.common.GuiCompressor;
import ic2.common.GuiElecFurnace;
import ic2.common.GuiExtractor;
import ic2.common.GuiInduction;
import ic2.common.GuiIronFurnace;
import ic2.common.GuiMacerator;
import ic2.common.Ic2Items;
import ic2.neiIntegration.common.AdvRecipeHandler;
import ic2.neiIntegration.common.AdvShapelessRecipeHandler;
import ic2.neiIntegration.common.CompressorRecipeHandler;
import ic2.neiIntegration.common.ExtractorRecipeHandler;
import ic2.neiIntegration.common.MaceratorRecipeHandler;
import ic2.neiIntegration.common.ScrapboxRecipeHandler;

public class NEIIC2Config
implements IConfigureNEI {
    public void loadConfig() {
        System.out.println("IC2 NEI Submodule initialized");
        API.registerRecipeHandler((ICraftingHandler)new AdvRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AdvRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new AdvShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AdvShapelessRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MaceratorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MaceratorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ExtractorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ExtractorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ScrapboxRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ScrapboxRecipeHandler());
        API.registerGuiOverlay(GuiMacerator.class, (String)"macerator", (int)5, (int)11);
        API.registerGuiOverlay(GuiExtractor.class, (String)"extractor", (int)5, (int)11);
        API.registerGuiOverlay(GuiCompressor.class, (String)"compressor", (int)5, (int)11);
        API.registerGuiOverlay(GuiIronFurnace.class, (String)"smelting", (int)5, (int)11);
        API.registerGuiOverlay(GuiElecFurnace.class, (String)"smelting", (int)5, (int)11);
        API.registerGuiOverlay(GuiInduction.class, (String)"smelting", (int)-4, (int)11);
        this.addSubsets();
    }

    public void addSubsets() {
        this.addSubset("IC2.Armor.Bronze", Ic2Items.bronzeHelmet.c, Ic2Items.bronzeChestplate.c, Ic2Items.bronzeLeggings.c, Ic2Items.bronzeBoots.c);
        this.addSubset("IC2.Armor.Nano", Ic2Items.nanoHelmet.c, Ic2Items.nanoBodyarmor.c, Ic2Items.nanoLeggings.c, Ic2Items.nanoBoots.c);
        this.addSubset("IC2.Armor.Quantum", Ic2Items.quantumHelmet.c, Ic2Items.quantumBodyarmor.c, Ic2Items.quantumLeggings.c, Ic2Items.quantumBoots.c);
        this.addSubset("IC2.Armor.Hazmat", Ic2Items.hazmatHelmet.c, Ic2Items.hazmatChestplate.c, Ic2Items.hazmatLeggings.c, Ic2Items.hazmatBoots.c);
        this.addSubset("IC2.Armor.Utility", Ic2Items.batPack.c, Ic2Items.cfPack.c, Ic2Items.compositeArmor.c, Ic2Items.electricJetpack.c, Ic2Items.jetpack.c, Ic2Items.lapPack.c, Ic2Items.solarHelmet.c, Ic2Items.staticBoots.c);
        this.addSubset("IC2.Wiring", Ic2Items.copperCableItem, Ic2Items.insulatedCopperCableItem, Ic2Items.goldCableItem, Ic2Items.insulatedGoldCableItem, Ic2Items.doubleInsulatedGoldCableItem, Ic2Items.ironCableItem, Ic2Items.insulatedIronCableItem, Ic2Items.doubleInsulatedIronCableItem, Ic2Items.trippleInsulatedIronCableItem, Ic2Items.glassFiberCableItem, Ic2Items.tinCableItem, Ic2Items.detectorCableItem, Ic2Items.splitterCableItem, Ic2Items.lvTransformer, Ic2Items.mvTransformer, Ic2Items.hvTransformer);
        this.addSubset("IC2.EU Storage", Ic2Items.batBox, Ic2Items.mfeUnit, Ic2Items.mfsUnit, Ic2Items.electrolyzedWaterCell.c, Ic2Items.energyCrystal.c, Ic2Items.lapotronCrystal.c, Ic2Items.suBattery.c, Ic2Items.reBattery.c, Ic2Items.chargedReBattery.c);
        this.addSubset("IC2.Machines.Generators", Ic2Items.generator, Ic2Items.geothermalGenerator, Ic2Items.nuclearReactor, Ic2Items.solarPanel, Ic2Items.windMill, Ic2Items.waterMill);
        this.addSubset("IC2.Machines.Gatherers", Ic2Items.miner, Ic2Items.pump);
        this.addSubset("IC2.Machines.Processors", Ic2Items.canner, Ic2Items.compressor, Ic2Items.electroFurnace, Ic2Items.extractor, Ic2Items.inductionFurnace, Ic2Items.ironFurnace, Ic2Items.macerator, Ic2Items.massFabricator, Ic2Items.recycler);
        this.addSubset("IC2.Machines.Utility", Ic2Items.electrolyzer, Ic2Items.magnetizer, Ic2Items.personalSafe, Ic2Items.teleporter, Ic2Items.terraformer, Ic2Items.teslaCoil, Ic2Items.tradeOMat, Ic2Items.energyOMat);
        this.addSubset("IC2.Tools.Electric", Ic2Items.chainsaw.c, Ic2Items.electricTreetap.c, Ic2Items.electricWrench.c, Ic2Items.electricHoe.c, Ic2Items.diamondDrill.c, Ic2Items.miningDrill.c, Ic2Items.miningLaser.c, Ic2Items.odScanner.c, Ic2Items.ovScanner.c);
        this.addSubset("IC2.Tools.Bronze", Ic2Items.bronzeAxe.c, Ic2Items.bronzeHoe.c, Ic2Items.bronzeShovel.c, Ic2Items.bronzePickaxe.c);
        this.addSubset("IC2.Tools.Utility", Ic2Items.ecMeter.c, Ic2Items.wrench.c, Ic2Items.treetap.c, Ic2Items.cutter.c, Ic2Items.constructionFoamSprayer.c);
    }

    private void addSubset(String name, Object ... items) {
        MultiItemRange multiitemrange = new MultiItemRange();
        for (Object item : items) {
            if (item instanceof rj) {
                multiitemrange.add((rj)item);
                continue;
            }
            multiitemrange.add(((Integer)item).intValue());
        }
        API.addSetRange((String)name, (MultiItemRange)multiitemrange);
    }

    public String getName() {
        return "IndustrialCraft 2";
    }

    public String getVersion() {
        return "1.106";
    }
}

