/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.ContainerIC2;
import ic2.common.ContainerWindGenerator;
import ic2.common.IC2;
import ic2.common.Ic2Items;
import ic2.common.StackUtil;
import ic2.common.TileEntityBaseGenerator;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityWindGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public double subproduction = 0.0;
    public double substorage = 0.0;
    public int ticker = randomizer.nextInt(this.tickRate());
    public int obscuratedBlockCount;

    public TileEntityWindGenerator() {
        super(1, 4, 4);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        double prod = this.subproduction / 3.0;
        int re = (int)(prod * (double)i);
        if (re < 0) {
            return 0;
        }
        if (re > i) {
            return i;
        }
        return re;
    }

    public int getOverheatScaled(int i) {
        double prod = (this.subproduction - 5.0) / 5.0;
        if (this.subproduction <= 5.0) {
            return 0;
        }
        if (this.subproduction >= 10.0) {
            return i;
        }
        return (int)(prod * (double)i);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateObscuratedBlockCount();
    }

    @Override
    public boolean gainEnergy() {
        ++this.ticker;
        if (this.ticker % this.tickRate() == 0) {
            if (this.ticker % (8 * this.tickRate()) == 0) {
                this.updateObscuratedBlockCount();
            }
            this.subproduction = (double)(IC2.windStrength * (this.m - 64 - this.obscuratedBlockCount)) / 750.0;
            if (this.subproduction <= 0.0) {
                return false;
            }
            if (this.k.I()) {
                this.subproduction *= 1.5;
            } else if (this.k.J()) {
                this.subproduction *= 1.2;
            }
            if (this.subproduction > 5.0 && (double)this.k.v.nextInt(5000) <= this.subproduction - 5.0) {
                this.subproduction = 0.0;
                this.k.d(this.l, this.m, this.n, Ic2Items.generator.c, Ic2Items.generator.j());
                for (int i = this.k.v.nextInt(5); i > 0; --i) {
                    StackUtil.dropAsEntity(this.k, this.l, this.m, this.n, new rj(rh.o));
                }
                return false;
            }
            this.subproduction *= (double)IC2.energyGeneratorWind;
            this.subproduction /= 100.0;
        }
        this.substorage += this.subproduction;
        this.production = (short)this.substorage;
        if (this.storage + this.production >= this.maxStorage) {
            this.substorage = 0.0;
            return false;
        }
        this.storage = (short)(this.storage + this.production);
        this.substorage -= (double)this.production;
        return true;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateObscuratedBlockCount() {
        this.obscuratedBlockCount = -1;
        for (int x = -4; x < 5; ++x) {
            for (int y = -2; y < 5; ++y) {
                for (int z = -4; z < 5; ++z) {
                    if (this.k.a(x + this.l, y + this.m, z + this.n) == 0) continue;
                    ++this.obscuratedBlockCount;
                }
            }
        }
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 10;
    }

    @Override
    public String b() {
        return "Wind Mill";
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiWindGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WindGenLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerWindGenerator(entityPlayer, this);
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

