/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.ITerraformingBP;
import ic2.common.AudioManager;
import ic2.common.AudioSource;
import ic2.common.IC2;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityElecMachine;

public class TileEntityTerra
extends TileEntityElecMachine {
    public int failedAttempts = 0;
    public int lastX = -1;
    public int lastY = -1;
    public int lastZ = -1;
    public AudioSource audioSource;
    public int inactiveTicks = 0;

    public TileEntityTerra() {
        super(1, 0, 100000, 512);
    }

    @Override
    public String b() {
        return "Terraformer";
    }

    @Override
    public void g() {
        ITerraformingBP tfbp;
        super.g();
        boolean newActive = false;
        if (this.inventory[0] != null && this.inventory[0].b() instanceof ITerraformingBP && this.energy >= (tfbp = (ITerraformingBP)this.inventory[0].b()).getConsume()) {
            newActive = true;
            int x = this.l;
            int z = this.n;
            int range = 1;
            if (this.lastY > -1) {
                range = tfbp.getRange() / 10;
                x = this.lastX - this.k.v.nextInt(range + 1) + this.k.v.nextInt(range + 1);
                z = this.lastZ - this.k.v.nextInt(range + 1) + this.k.v.nextInt(range + 1);
            } else {
                if (this.failedAttempts > 4) {
                    this.failedAttempts = 4;
                }
                range = tfbp.getRange() * (this.failedAttempts + 1) / 5;
                x = x - this.k.v.nextInt(range + 1) + this.k.v.nextInt(range + 1);
                z = z - this.k.v.nextInt(range + 1) + this.k.v.nextInt(range + 1);
            }
            if (tfbp.terraform(this.k, x, z, this.m)) {
                this.energy -= tfbp.getConsume();
                this.failedAttempts = 0;
                this.lastX = x;
                this.lastZ = z;
                this.lastY = this.m;
            } else {
                this.energy -= tfbp.getConsume() / 10;
                ++this.failedAttempts;
                this.lastY = -1;
            }
        }
        if (newActive) {
            this.inactiveTicks = 0;
            this.setActive(true);
        } else if (!newActive && this.getActive() && this.inactiveTicks++ > 30) {
            this.setActive(false);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > 512) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        if (this.energy + amount > this.maxEnergy) {
            int unused = this.energy + amount - this.maxEnergy;
            this.energy = this.maxEnergy;
            return unused;
        }
        this.energy += amount;
        return 0;
    }

    public boolean ejectBlueprint() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            StackUtil.dropAsEntity(this.k, this.l, this.m, this.n, this.inventory[0]);
            this.inventory[0] = null;
        }
        return true;
    }

    public void insertBlueprint(rj tfbp) {
        this.ejectBlueprint();
        this.inventory[0] = tfbp;
    }

    public static int getFirstSolidBlockFrom(up world, int x, int z, int y) {
        while (y > 0) {
            if (world.r(x, y, z)) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static int getFirstBlockFrom(up world, int x, int z, int y) {
        while (y > 0) {
            if (world.a(x, y, z) != 0) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static boolean switchGround(up world, aig from, aig to, int x, int y, int z, boolean upwards) {
        int id;
        if (upwards) {
            int id2;
            int saveY = ++y;
            while ((id2 = world.a(x, y - 1, z)) != 0 && aig.m[id2] == from) {
                --y;
            }
            if (saveY == y) {
                return false;
            }
            world.e(x, y, z, to.ca);
            return true;
        }
        while ((id = world.a(x, y, z)) != 0 && aig.m[id] == to) {
            --y;
        }
        id = world.a(x, y, z);
        if (id == 0 || aig.m[id] != from) {
            return false;
        }
        world.e(x, y, z, to.ca);
        return true;
    }

    public static vk getBiomeAt(up world, int x, int z) {
        return world.d(x, z).a(x & 0xF, z & 0xF, world.r());
    }

    public static void setBiomeAt(up world, int x, int z, vk biome) {
        wl chunk = world.d(x, z);
        byte[] array = chunk.m();
        array[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.M & 0xFF);
        chunk.a(array);
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Terraformers/TerraformerGenericloop.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

