/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.INetworkTileEntityEventListener;
import ic2.common.AudioManager;
import ic2.common.AudioPosition;
import ic2.common.AudioSource;
import ic2.common.IC2;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityElectricBlock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    private AudioSource audioSource = null;
    private static final int EventTeleport = 0;

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.targetSet = nbttagcompound.n("targetSet");
        this.targetX = nbttagcompound.e("targetX");
        this.targetY = nbttagcompound.e("targetY");
        this.targetZ = nbttagcompound.e("targetZ");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetSet", this.targetSet);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void g() {
        super.g();
        if (IC2.platform.isSimulating()) {
            if (this.k.z(this.l, this.m, this.n) && this.targetSet) {
                boolean prevWorldChunkLoadOverride = this.k.B;
                this.k.B = true;
                wl chunk = this.k.F().d(this.targetX >> 4, this.targetZ >> 4);
                this.k.B = prevWorldChunkLoadOverride;
                if (chunk == null || chunk.a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.c || chunk.c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.j()) {
                    this.targetSet = false;
                    this.setActive(false);
                } else {
                    this.setActive(true);
                    List entitiesNearby = this.k.a(jn.class, ajn.a((double)(this.l - 1), (double)this.m, (double)(this.n - 1), (double)(this.l + 2), (double)(this.m + 3), (double)(this.n + 2)));
                    if (!entitiesNearby.isEmpty()) {
                        double minDistanceSquared = Double.MAX_VALUE;
                        jn closestEntity = null;
                        for (jn entity : entitiesNearby) {
                            double distSquared;
                            if (entity.o != null || !((distSquared = ((double)this.l - entity.t) * ((double)this.l - entity.t) + ((double)(this.m + 1) - entity.u) * ((double)(this.m + 1) - entity.u) + ((double)this.n - entity.v) * ((double)this.n - entity.v)) < minDistanceSquared)) continue;
                            minDistanceSquared = distSquared;
                            closestEntity = entity;
                        }
                        this.teleport(closestEntity);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (IC2.platform.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.l, this.m, this.n);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void teleport(jn user) {
        double distance = Math.sqrt((this.l - this.targetX) * (this.l - this.targetX) + (this.m - this.targetY) * (this.m - this.targetY) + (this.n - this.targetZ) * (this.n - this.targetZ));
        int weight = this.getWeightOf(user);
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        if (user instanceof gu) {
            ((gu)user).a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.W(), (double)this.targetZ + 0.5);
        } else {
            user.a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.W(), (double)this.targetZ + 0.5, user.z, user.A);
        }
        IC2.network.initiateTileEntityEvent(this, 0, true);
        if (user instanceof og && distance >= 1000.0) {
            IC2.achievements.issueAchievement((og)user, "teleportFarAway");
        }
    }

    public void spawnBlueParticles(int n, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            this.k.a("reddust", (double)((float)x + this.k.v.nextFloat()), (double)((float)(y + 1) + this.k.v.nextFloat()), (double)((float)z + this.k.v.nextFloat()), -1.0, 0.0, 1.0);
            this.k.a("reddust", (double)((float)x + this.k.v.nextFloat()), (double)((float)(y + 2) + this.k.v.nextFloat()), (double)((float)z + this.k.v.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void consumeEnergy(int energy) {
        LinkedList<TileEntityElectricBlock> energySources = new LinkedList<TileEntityElectricBlock>();
        for (Direction direction : Direction.values()) {
            aji target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            TileEntityElectricBlock energySource = (TileEntityElectricBlock)target;
            if (energySource.energy <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it = energySources.iterator();
            while (it.hasNext()) {
                TileEntityElectricBlock energySource = (TileEntityElectricBlock)it.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource.energy <= drain) {
                    energy -= energySource.energy;
                    energySource.energy = 0;
                    it.remove();
                    continue;
                }
                energy -= drain;
                energySource.energy -= drain;
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : Direction.values()) {
            aji target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            energy += ((TileEntityElectricBlock)target).energy;
        }
        return energy;
    }

    public int getWeightOf(jn user) {
        int weight = 0;
        jn ce2 = user;
        while (ce2 != null) {
            if (ce2 instanceof nj) {
                rj is = ((nj)ce2).a;
                weight += 100 * is.a / is.d();
            } else if (ce2 instanceof mn || ce2 instanceof nk || ce2 instanceof nh) {
                weight += 100;
            } else if (ce2 instanceof og) {
                weight += 1000;
                if (IC2.enableTeleporterInventory) {
                    int i;
                    of inv = ((og)ce2).by;
                    for (i = 0; i < inv.a.length; ++i) {
                        if (inv.a[i] == null) continue;
                        weight += 100 * inv.a[i].a / inv.a[i].d();
                    }
                    for (i = 0; i < inv.b.length; ++i) {
                        if (inv.b[i] == null) continue;
                        weight += 100;
                    }
                }
            } else if (ce2 instanceof nr) {
                weight += 2500;
            } else if (ce2 instanceof nd) {
                weight += 10000;
            } else if (ce2 instanceof kb) {
                weight += 500;
            }
            ce2 = ce2.n;
        }
        return weight;
    }

    public void setTarget(int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        IC2.network.updateTileEntityField(this, "targetX");
        IC2.network.updateTileEntityField(this, "targetY");
        IC2.network.updateTileEntityField(this, "targetZ");
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(3);
        ret.add("targetX");
        ret.add("targetY");
        ret.add("targetZ");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                IC2.audioManager.playOnce(new AudioPosition(this.k, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                this.spawnBlueParticles(20, this.l, this.m, this.n);
                this.spawnBlueParticles(20, this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.l + "," + this.m + "," + this.n + ")");
            }
        }
    }
}

