/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.ContainerIC2;
import ic2.common.ContainerSolarGenerator;
import ic2.common.IC2;
import ic2.common.TileEntityBaseGenerator;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntitySolarGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public int ticker = randomizer.nextInt(this.tickRate());
    public boolean sunIsVisible = false;

    public TileEntitySolarGenerator() {
        super(1, 1, 1);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateSunVisibility();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        return i;
    }

    @Override
    public boolean gainEnergy() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateSunVisibility();
        }
        if (this.sunIsVisible) {
            if (randomizer.nextInt(100) < IC2.energyGeneratorSolar) {
                this.storage = (short)(this.storage + 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.sunIsVisible = TileEntitySolarGenerator.isSunVisible(this.k, this.l, this.m + 1, this.n);
    }

    public static boolean isSunVisible(up world, int x, int y, int z) {
        return world.s() && !world.w.e && world.j(x, y, z) && (world.r().a(x, z) instanceof vq || !world.J() && !world.I());
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String b() {
        return "Solar Panel";
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerSolarGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiSolarGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

