/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.AudioManager;
import ic2.common.AudioSource;
import ic2.common.ContainerIC2;
import ic2.common.ContainerPump;
import ic2.common.IC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityElecMachine;
import ic2.common.TileEntityGeoGenerator;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class TileEntityPump
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = IC2.random.nextInt(64);
    public short pumpCharge = 0;
    private AudioSource audioSource;

    public TileEntityPump() {
        super(2, 1, 200, 32);
    }

    @Override
    public String b() {
        return "Pump";
    }

    @Override
    public void g() {
        super.g();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && !this.isPumpReady()) {
            --this.energy;
            this.pumpCharge = (short)(this.pumpCharge + 1);
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (this.isPumpReady()) {
            needsInvUpdate = this.pump();
        }
        if (this.getActive() == this.isPumpReady() && this.energy > 0) {
            this.setActive(!this.getActive());
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean pump() {
        if (!this.canHarvest()) {
            return false;
        }
        if (this.isWaterBelow() || this.isLavaBelow()) {
            int id = this.k.a(this.l, this.m - 1, this.n);
            this.k.e(this.l, this.m - 1, this.n, 0);
            if (id == aig.A.ca) {
                id = aig.B.ca;
            }
            if (id == aig.C.ca) {
                id = aig.D.ca;
            }
            return this.pumpThis(id);
        }
        if (this.inventory[0] != null && this.inventory[0].c == rh.aw.bT) {
            Object customBucket = null;
            MinecraftForge.EVENT_BUS.post((Event)new FillBucketEvent(null, customBucket, this.k, new ajq(this.l, this.m - 1, this.n, 1, null)));
            if (customBucket != null) {
                ArrayList<Object> drops = new ArrayList<Object>();
                drops.add(customBucket);
                StackUtil.distributeDrop(this, drops);
                this.inventory[0] = null;
                this.pumpCharge = 0;
                return true;
            }
        }
        return false;
    }

    public boolean isWaterBelow() {
        return (this.k.a(this.l, this.m - 1, this.n) == aig.A.ca || this.k.a(this.l, this.m - 1, this.n) == aig.B.ca) && this.k.g(this.l, this.m - 1, this.n) == 0;
    }

    public boolean isLavaBelow() {
        return (this.k.a(this.l, this.m - 1, this.n) == aig.C.ca || this.k.a(this.l, this.m - 1, this.n) == aig.D.ca) && this.k.g(this.l, this.m - 1, this.n) == 0;
    }

    public boolean pumpThis(int id) {
        if (id == aig.D.ca && this.deliverLavaToGeo()) {
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].c == rh.aw.bT) {
            if (id == aig.B.ca) {
                this.inventory[0].c = rh.ax.bT;
            }
            if (id == aig.D.ca) {
                this.inventory[0].c = rh.ay.bT;
            }
            ArrayList<rj> drops = new ArrayList<rj>();
            drops.add(this.inventory[0]);
            StackUtil.distributeDrop(this, drops);
            this.inventory[0] = null;
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].c == Ic2Items.cell.c) {
            rj drop = null;
            if (id == aig.B.ca) {
                drop = Ic2Items.waterCell.l();
            }
            if (id == aig.D.ca) {
                drop = Ic2Items.lavaCell.l();
            }
            --this.inventory[0].a;
            if (this.inventory[0].a <= 0) {
                this.inventory[0] = null;
            }
            ArrayList<rj> drops = new ArrayList<rj>();
            drops.add(drop);
            StackUtil.distributeDrop(this, drops);
            this.pumpCharge = 0;
            return true;
        }
        this.pumpCharge = 0;
        return this.putInChestBucket(id);
    }

    public boolean putInChestBucket(int id) {
        return this.putInChestBucket(this.l, this.m + 1, this.n, id) || this.putInChestBucket(this.l, this.m - 1, this.n, id) || this.putInChestBucket(this.l + 1, this.m, this.n, id) || this.putInChestBucket(this.l - 1, this.m, this.n, id) || this.putInChestBucket(this.l, this.m, this.n + 1, id) || this.putInChestBucket(this.l, this.m, this.n - 1, id);
    }

    public boolean putInChestBucket(int x, int y, int z, int id) {
        if (!(this.k.p(x, y, z) instanceof aiz)) {
            return false;
        }
        aiz chest = (aiz)this.k.p(x, y, z);
        for (int i = 0; i < chest.i_(); ++i) {
            if (chest.a(i) == null || chest.a((int)i).c != rh.aw.bT) continue;
            if (id == aig.B.ca) {
                chest.a((int)i).c = rh.ax.bT;
            }
            if (id == aig.D.ca) {
                chest.a((int)i).c = rh.ay.bT;
            }
            return true;
        }
        return false;
    }

    public void fountain() {
        if (this.k.D() % 10L == 0L) {
            this.pumpCharge = (short)(this.pumpCharge - 1);
        }
        int y = 0;
        for (int x = 1; x < 4; ++x) {
            if (this.k.a(this.l, this.m + x, this.n) != 0 && this.k.a(this.l, this.m + x, this.n) != aig.A.ca) continue;
            y = x;
        }
        if (y != 0) {
            this.k.d(this.l, this.m + y, this.n, aig.A.ca, 1);
        }
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.pumpCharge = nbttagcompound.d("pumpCharge");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("pumpCharge", this.pumpCharge);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        if (!this.isPumpReady()) {
            return false;
        }
        return this.inventory[0] != null && (this.inventory[0].c == Ic2Items.cell.c || this.inventory[0].c == rh.aw.bT) || this.isBucketInChestAvaible();
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.l, this.m + 1, this.n) || this.isBucketInChestAvaible(this.l, this.m - 1, this.n) || this.isBucketInChestAvaible(this.l + 1, this.m, this.n) || this.isBucketInChestAvaible(this.l - 1, this.m, this.n) || this.isBucketInChestAvaible(this.l, this.m, this.n + 1) || this.isBucketInChestAvaible(this.l, this.m, this.n - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.k.p(x, y, z) instanceof aiz)) {
            return false;
        }
        aiz chest = (aiz)this.k.p(x, y, z);
        for (int i = 0; i < chest.i_(); ++i) {
            if (chest.a(i) == null || chest.a((int)i).c != rh.aw.bT) continue;
            return true;
        }
        return false;
    }

    public boolean deliverLavaToGeo() {
        int lava = 3000;
        if (lava > 0 && this.k.p(this.l, this.m + 1, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l, this.m + 1, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.p(this.l, this.m - 1, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l, this.m - 1, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.p(this.l + 1, this.m, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l + 1, this.m, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.p(this.l - 1, this.m, this.n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l - 1, this.m, this.n)).distributeLava(lava);
        }
        if (lava > 0 && this.k.p(this.l, this.m, this.n + 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l, this.m, this.n + 1)).distributeLava(lava);
        }
        if (lava > 0 && this.k.p(this.l, this.m, this.n - 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.k.p(this.l, this.m, this.n - 1)).distributeLava(lava);
        }
        return lava < 2980;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiPump";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

