/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergySource;
import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.common.AudioManager;
import ic2.common.AudioSource;
import ic2.common.ContainerIC2;
import ic2.common.ContainerNuclearReactor;
import ic2.common.EnergyNet;
import ic2.common.ExplosionIC2;
import ic2.common.IC2;
import ic2.common.IC2DamageSource;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityMachine;
import ic2.common.TileEntityReactorChamber;
import java.util.List;
import java.util.Random;

public class TileEntityNuclearReactor
extends TileEntityMachine
implements IEnergySource,
IHasGui,
IReactor {
    public static Random randomizer = new Random();
    public short output = 0;
    public int updateTicker = randomizer.nextInt(this.getTickRate());
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    private short lastOutput = 0;

    public TileEntityNuclearReactor() {
        super(54);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        super.onUnloaded();
    }

    @Override
    public String b() {
        return "Nuclear Reactor";
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.heat = nbttagcompound.e("heat");
        }
        catch (Exception e) {
            this.heat = nbttagcompound.d("heat");
        }
        this.output = nbttagcompound.d("output");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("output", this.output);
    }

    @Override
    public void g() {
        super.g();
        if (!this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
        this.sendEnergy(this.output);
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (!this.k.a(this.l, this.m, this.n, 2)) {
            this.output = 0;
        } else {
            this.dropAllUnfittingStuff();
            this.output = 0;
            this.maxHeat = 10000;
            this.hem = 1.0f;
            this.processChambers();
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.heat >= 1000 || this.output > 0);
            this.d();
        }
        IC2.network.updateTileEntityField(this, "output");
    }

    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                rj stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactor.isUsefulItem(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public static boolean isUsefulItem(rj item) {
        if (item == null) {
            return false;
        }
        if (item.b() instanceof IReactorComponent) {
            return true;
        }
        int id = item.c;
        return id == Ic2Items.reEnrichedUraniumCell.c || id == Ic2Items.nearDepletedUraniumCell.c;
    }

    public void eject(rj drop) {
        if (!IC2.platform.isSimulating() || drop == null) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.k.v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.k.v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.k.v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        nj entityitem = new nj(this.k, (double)this.l + d, (double)this.m + d1, (double)this.n + d2, drop);
        entityitem.c = 10;
        this.k.d((jn)entityitem);
    }

    public boolean calculateHeatEffects() {
        aco mat;
        int id;
        int[] coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.k.v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
            id = this.k.a(coord[0], coord[1], coord[2]);
            if (id == 0) {
                this.k.e(coord[0], coord[1], coord[2], aig.ar.ca);
            } else if (id != aig.z.ca) {
                mat = aig.m[id].cp;
                if (mat == aco.e || mat == aco.f || mat == aco.h || mat == aco.c || mat == aco.y) {
                    this.k.d(coord[0], coord[1], coord[2], aig.C.ca, 15);
                } else {
                    this.k.e(coord[0], coord[1], coord[2], aig.ar.ca);
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.k.a(jw.class, ajn.a((double)(this.l - 3), (double)(this.m - 3), (double)(this.n - 3), (double)(this.l + 4), (double)(this.m + 4), (double)(this.n + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                jn ent = (jn)list1.get(l);
                ent.a((je)IC2DamageSource.radiation, (int)((float)this.k.v.nextInt(4) * this.hem));
            }
        }
        if (power >= 0.5f && this.k.v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.k.a(coord[0], coord[1], coord[2])) > 0 && aig.m[id].cp == aco.g) {
            this.k.e(coord[0], coord[1], coord[2], 0);
        }
        if (power >= 0.4f && this.k.v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.k.a(coord[0], coord[1], coord[2])) > 0 && ((mat = aig.m[id].cp) == aco.d || mat == aco.i || mat == aco.m)) {
            this.k.e(coord[0], coord[1], coord[2], aig.ar.ca);
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.l + this.k.v.nextInt(2 * radius + 1) - radius, this.m + this.k.v.nextInt(2 * radius + 1) - radius, this.n + this.k.v.nextInt(2 * radius + 1) - radius};
        if (c[0] == this.l && c[1] == this.m && c[2] == this.n) {
            return null;
        }
        return c;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                rj thing = this.getMatrixCoord(x, y);
                if (thing == null || !(thing.b() instanceof IReactorComponent)) continue;
                IReactorComponent comp = (IReactorComponent)thing.b();
                comp.processChamber(this, thing, x, y);
            }
        }
    }

    @Override
    public boolean produceEnergy() {
        return this.k.z(this.l, this.m, this.n) && IC2.energyGeneratorNuclear != 0;
    }

    public rj getMatrixCoord(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return null;
        }
        return super.a(x + y * 9);
    }

    @Override
    public rj a(int i) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            return this.getMatrixCoord(size - 1, i / 9);
        }
        return super.a(i);
    }

    public void setMatrixCoord(int x, int y, rj stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        super.a(x + y * 9, stack);
    }

    @Override
    public void a(int i, rj itemstack) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            this.setMatrixCoord(size - 1, i / 9, itemstack);
        } else {
            super.a(i, itemstack);
        }
    }

    public short getReactorSize() {
        if (this.k == null) {
            return 9;
        }
        short rows = 3;
        for (Direction direction : Direction.values()) {
            aji target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            rows = (short)(rows + 1);
        }
        return rows;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    public static int pulsePower() {
        return IC2.energyGeneratorNuclear;
    }

    @Override
    public int getPulsePower() {
        return IC2.energyGeneratorNuclear;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(aji receiver, Direction direction) {
        return true;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 1512 * TileEntityNuclearReactor.pulsePower();
    }

    public int sendEnergy(int send) {
        send = EnergyNet.getForWorld(this.k).emitEnergyFrom(this, send);
        if (send > 0 && this.k.p(this.l, this.m + 1, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l, this.m + 1, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.p(this.l, this.m - 1, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l, this.m - 1, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.p(this.l + 1, this.m, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l + 1, this.m, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.p(this.l - 1, this.m, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l - 1, this.m, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.p(this.l, this.m, this.n + 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l, this.m, this.n + 1)).sendEnergy(send);
        }
        if (send > 0 && this.k.p(this.l, this.m, this.n - 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.p(this.l, this.m, this.n - 1)).sendEnergy(send);
        }
        return send;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerNuclearReactor(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiNuclearReactor";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0) {
                if (this.lastOutput <= 0) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40) {
                    if (this.lastOutput <= 0 || this.lastOutput >= 40) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80) {
                    if (this.lastOutput < 40 || this.lastOutput >= 80) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80 && this.lastOutput < 80) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, AudioManager.defaultVolume);
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public j getPosition() {
        return new j(this.l, this.m, this.n);
    }

    @Override
    public up getWorld() {
        return this.k;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public rj getItemAt(int x, int y) {
        return this.getMatrixCoord(x, y);
    }

    @Override
    public void setItemAt(int x, int y, rj item) {
        this.setMatrixCoord(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                rj stack = this.getMatrixCoord(x, y);
                if (stack != null && stack.b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.b()).influenceExplosion(this, stack);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setMatrixCoord(x, y, null);
            }
        }
        if ((boomPower *= this.hem * boomMod) > IC2.explosionPowerReactorMax) {
            boomPower = IC2.explosionPowerReactorMax;
        }
        for (Direction direction : Direction.values()) {
            aji target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            this.k.e(target.l, target.m, target.n, 0);
        }
        this.k.e(this.l, this.m, this.n, 0);
        ExplosionIC2 explosion = new ExplosionIC2(this.k, null, this.l, this.m, this.n, boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public int addOutput(int energy) {
        this.output = (short)(this.output + energy);
        return this.output;
    }
}

