/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.common.AudioManager;
import ic2.common.AudioSource;
import ic2.common.ContainerIC2;
import ic2.common.ContainerMatter;
import ic2.common.ExplosionIC2;
import ic2.common.IC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityElecMachine;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityMatter
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    public static Vector amplifiers = new Vector();
    private final int StateIdle = 0;
    private final int StateRunning = 1;
    private final int StateRunningScrap = 2;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityMatter() {
        super(2, 0, 1100000, 512);
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.d("scrap");
        }
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("scrap", this.scrap);
    }

    @Override
    public String b() {
        return "Mass Fabricator";
    }

    @Override
    public void g() {
        super.g();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
        } else {
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            boolean needsInvUpdate = false;
            if (this.scrap < 1000 && this.inventory[0] != null) {
                for (Map.Entry amplifier : amplifiers) {
                    if (!this.inventory[0].a((rj)amplifier.getKey())) continue;
                    if (((rj)amplifier.getKey()).b().r()) {
                        this.inventory[0] = new rj(((rj)amplifier.getKey()).b().q());
                    } else {
                        --this.inventory[0].a;
                        if (this.inventory[0].a <= 0) {
                            this.inventory[0] = null;
                        }
                    }
                    this.scrap += ((Integer)amplifier.getValue()).intValue();
                    break;
                }
            }
            if (this.energy >= 1000000) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (needsInvUpdate) {
                this.d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        if (this.inventory[1] == null) {
            this.inventory[1] = Ic2Items.matter.l();
            this.energy -= 1000000;
            return true;
        }
        if (!this.inventory[1].a(Ic2Items.matter) || this.inventory[1].a >= this.inventory[1].d()) {
            return false;
        }
        this.energy -= 1000000;
        ++this.inventory[1].a;
        return true;
    }

    @Override
    public boolean demandsEnergy() {
        if (this.isRedstonePowered()) {
            return false;
        }
        return this.energy < this.maxEnergy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > 512) {
            this.k.e(this.l, this.m, this.n, 0);
            ExplosionIC2 explosion = new ExplosionIC2(this.k, null, this.l, this.m, this.n, 15.0f, 0.01f, 1.5f);
            explosion.doExplosion();
            return 0;
        }
        int bonus = amount;
        if (bonus > this.scrap) {
            bonus = this.scrap;
        }
        this.scrap -= bonus;
        this.energy += amount + 5 * bonus;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    public String getProgressAsString() {
        int p = this.energy / 10000;
        if (p > 100) {
            p = 100;
        }
        return "" + p + "%";
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerMatter(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiMatter";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            IC2.network.updateTileEntityField(this, "state");
        }
        this.prevState = state;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.7f;
    }
}

