/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.common.ContainerIC2;
import ic2.common.ContainerInduction;
import ic2.common.IC2;
import ic2.common.IHasGui;
import ic2.common.TileEntityElecMachine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityInduction
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = IC2.random.nextInt(64);
    public static short maxHeat = (short)10000;
    public short heat = 0;
    public short progress = 0;
    private static final int inputSlot = 0;
    private static final int fuelSlot = 2;
    private static final int outputSlot = 3;

    public TileEntityInduction() {
        super(5, 2, maxHeat, 128, 2);
    }

    @Override
    public String b() {
        if (IC2.platform.isRendering()) {
            return "Induction Furnace";
        }
        return "InductionFurnace";
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.heat = nbttagcompound.d("heat");
        this.progress = nbttagcompound.d("progress");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("progress", this.progress);
    }

    public String getHeat() {
        return "" + this.heat * 100 / maxHeat + "%";
    }

    public int gaugeProgressScaled(int i) {
        return i * this.progress / 4000;
    }

    public int gaugeFuelScaled(int i) {
        return i * this.energy / this.maxEnergy;
    }

    @Override
    public void g() {
        super.g();
        boolean needsInvUpdate = false;
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.heat == 0) {
            newActive = false;
        }
        if (this.progress >= 4000) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
        }
        boolean canOperate = this.canOperate();
        if (this.energy > 0 && (canOperate || this.isRedstonePowered())) {
            --this.energy;
            if (this.heat < maxHeat) {
                this.heat = (short)(this.heat + 1);
            }
            newActive = true;
        } else {
            this.heat = (short)(this.heat - Math.min(this.heat, 4));
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= 15) {
                    newActive = true;
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < 15) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive && canOperate) {
            this.progress = (short)(this.progress + this.heat / 30);
            this.energy -= 15;
        }
        if (needsInvUpdate) {
            this.d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate() {
        this.operate(0, 3);
        this.operate(1, 4);
    }

    public void operate(int input, int output) {
        if (!this.canOperate(input, output)) {
            return;
        }
        rj itemstack = this.getResultFor(this.inventory[input]);
        if (this.inventory[output] == null) {
            this.inventory[output] = itemstack.l();
        } else {
            this.inventory[output].a += itemstack.a;
        }
        if (this.inventory[input].b().r()) {
            this.inventory[input] = new rj(this.inventory[input].b().q());
        } else {
            --this.inventory[input].a;
        }
        if (this.inventory[input].a <= 0) {
            this.inventory[input] = null;
        }
    }

    public boolean canOperate() {
        return this.canOperate(0, 3) || this.canOperate(1, 4);
    }

    public boolean canOperate(int input, int output) {
        if (this.inventory[input] == null) {
            return false;
        }
        rj itemstack = this.getResultFor(this.inventory[input]);
        if (itemstack == null) {
            return false;
        }
        return this.inventory[output] == null || this.inventory[output].a(itemstack) && this.inventory[output].a + itemstack.a <= itemstack.d();
    }

    public rj getResultFor(rj itemstack) {
        return tb.a().getSmeltingResult(itemstack);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > 128) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        this.energy += amount;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerInduction(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiInduction";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side.flag) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return 3;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }
}

