/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.ContainerBaseGenerator;
import ic2.common.ContainerIC2;
import ic2.common.IC2;
import ic2.common.Ic2Items;
import ic2.common.TileEntityBaseGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public int maxLava = 24000;

    public TileEntityGeoGenerator() {
        super(2, IC2.energyGeneratorGeo, IC2.energyGeneratorGeo);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] == null || this.maxLava - this.fuel < 1000) {
            return false;
        }
        if (this.inventory[1].c == rh.ay.bT) {
            this.fuel += 1000;
            this.inventory[1].c = rh.aw.bT;
            return true;
        }
        if (this.inventory[1].c == Ic2Items.lavaCell.c) {
            this.fuel += 1000;
            --this.inventory[1].a;
            if (this.inventory[1].a <= 0) {
                this.inventory[1] = null;
            }
            return true;
        }
        if (this.gainFuelSub(this.inventory[1])) {
            this.fuel += 1000;
            if (this.inventory[1].b().r()) {
                this.inventory[1] = new rj(this.inventory[1].b().q());
            } else {
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean gainFuelSub(rj stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String b() {
        if (IC2.platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerBaseGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiGeoGenerator";
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

