/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.ContainerElectrolyzer;
import ic2.common.ContainerIC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.TileEntityElectricBlock;
import ic2.common.TileEntityMachine;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityElectrolyzer
extends TileEntityMachine
implements IHasGui,
ISidedInventory {
    public static Random randomizer = new Random();
    public short energy = 0;
    public TileEntityElectricBlock mfe = null;
    public int ticker = randomizer.nextInt(16);

    public TileEntityElectrolyzer() {
        super(2);
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.d("energy");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.energy);
    }

    @Override
    public String b() {
        return "Electrolyzer";
    }

    @Override
    public void g() {
        super.g();
        boolean needsInvUpdate = false;
        boolean turnActive = false;
        if (this.ticker++ % 16 == 0) {
            this.mfe = this.lookForMFE();
        }
        if (this.mfe == null) {
            return;
        }
        if (this.shouldDrain() && this.canDrain()) {
            needsInvUpdate = this.drain();
            turnActive = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy > 0)) {
            needsInvUpdate = this.power();
            turnActive = true;
        }
        if (this.getActive() != turnActive) {
            this.setActive(turnActive);
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    public boolean shouldDrain() {
        return this.mfe != null && (double)this.mfe.energy / (double)this.mfe.maxStorage >= 0.7;
    }

    public boolean shouldPower() {
        return this.mfe != null && (double)this.mfe.energy / (double)this.mfe.maxStorage <= 0.3;
    }

    public boolean canDrain() {
        return this.inventory[0] != null && this.inventory[0].a(Ic2Items.waterCell) && (this.inventory[1] == null || this.inventory[1].a(Ic2Items.electrolyzedWaterCell) && this.inventory[1].a < this.inventory[1].d());
    }

    public boolean canPower() {
        return (this.inventory[0] == null || this.inventory[0].a(Ic2Items.waterCell) && this.inventory[0].a < this.inventory[0].d()) && this.inventory[1] != null && this.inventory[1].a(Ic2Items.electrolyzedWaterCell);
    }

    public boolean drain() {
        this.mfe.energy -= this.processRate();
        this.energy = (short)(this.energy + this.processRate());
        if (this.energy >= 20000) {
            this.energy = (short)(this.energy - 20000);
            --this.inventory[0].a;
            if (this.inventory[0].a <= 0) {
                this.inventory[0] = null;
            }
            if (this.inventory[1] == null) {
                this.inventory[1] = Ic2Items.electrolyzedWaterCell.l();
            } else {
                ++this.inventory[1].a;
            }
            return true;
        }
        return false;
    }

    public boolean power() {
        if (this.energy > 0) {
            int out = this.processRate();
            if (out > this.energy) {
                out = this.energy;
            }
            this.energy = (short)(this.energy - out);
            this.mfe.energy += out;
            return false;
        }
        this.energy = (short)(this.energy + (12000 + 2000 * this.mfe.tier));
        --this.inventory[1].a;
        if (this.inventory[1].a <= 0) {
            this.inventory[1] = null;
        }
        if (this.inventory[0] == null) {
            this.inventory[0] = Ic2Items.waterCell.l();
        } else {
            ++this.inventory[0].a;
        }
        return true;
    }

    public int processRate() {
        switch (this.mfe.tier) {
            default: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: 
        }
        return 32;
    }

    public TileEntityElectricBlock lookForMFE() {
        if (this.k.p(this.l, this.m - 1, this.n) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l, this.m - 1, this.n);
        }
        if (this.k.p(this.l, this.m + 1, this.n) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l, this.m + 1, this.n);
        }
        if (this.k.p(this.l - 1, this.m, this.n) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l - 1, this.m, this.n);
        }
        if (this.k.p(this.l + 1, this.m, this.n) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l + 1, this.m, this.n);
        }
        if (this.k.p(this.l, this.m, this.n - 1) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l, this.m, this.n - 1);
        }
        if (this.k.p(this.l, this.m, this.n + 1) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.k.p(this.l, this.m, this.n + 1);
        }
        return null;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 20000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiElectrolyzer";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

