/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.api.IEnergyStorage;
import ic2.api.INetworkClientTileEntityEventListener;
import ic2.common.ContainerElectricBlock;
import ic2.common.ContainerIC2;
import ic2.common.ElectricItem;
import ic2.common.EnergyNet;
import ic2.common.IC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.TileEntityMachine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEnergySource,
IHasGui,
ISidedInventory,
INetworkClientTileEntityEventListener,
IEnergyStorage {
    public ak translate;
    public int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)6;
    public boolean addedToEnergyNet = false;

    public TileEntityElectricBlock(int tierc, int outputc, int maxStoragec) {
        super(2);
        this.tier = tierc;
        this.output = outputc;
        this.maxStorage = maxStoragec;
        this.translate = ak.a();
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return this.translate.b("blockBatBox.name");
            }
            case 2: {
                return this.translate.b("blockMFE.name");
            }
            case 3: {
                return this.translate.b("blockMFSU.name");
            }
        }
        return null;
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.n("active"));
        this.energy = nbttagcompound.e("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.c("redstoneMode");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.a("energy", write);
        nbttagcompound.a("active", this.getActive());
        nbttagcompound.a("redstoneMode", this.redstoneMode);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void g() {
        super.g();
        boolean needsInvUpdate = false;
        boolean wasEmittingRedstone = this.isEmittingRedstone();
        if (this.energy > 0 && this.inventory[0] != null && rh.e[this.inventory[0].c] instanceof IElectricItem) {
            int sent = ElectricItem.charge(this.inventory[0], this.energy, this.tier, false, false);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandsEnergy() && this.inventory[1] != null) {
            if (rh.e[this.inventory[1].c] instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)rh.e[this.inventory[1].c];
                if (item.canProvideEnergy()) {
                    int gain = ElectricItem.discharge(this.inventory[1], this.maxStorage - this.energy, this.tier, false, false);
                    this.energy += gain;
                    needsInvUpdate = gain > 0;
                }
            } else {
                int id = this.inventory[1].c;
                int gain = 0;
                if (id == rh.aC.bT) {
                    gain = 500;
                }
                if (id == Ic2Items.suBattery.c) {
                    gain = 1000;
                }
                if (gain > 0 && gain <= this.maxStorage - this.energy) {
                    --this.inventory[1].a;
                    if (this.inventory[1].a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.energy += gain;
                }
            }
        }
        boolean isFull = false;
        if (this.energy >= this.maxStorage) {
            isFull = true;
        }
        this.setActive(isFull);
        if (wasEmittingRedstone != this.isEmittingRedstone()) {
            this.k.h(this.l, this.m, this.n, this.k.a(this.l, this.m, this.n));
        }
        if (!(this.energy < this.output || this.redstoneMode == 4 && this.k.y(this.l, this.m, this.n) || this.redstoneMode == 5 && this.k.y(this.l, this.m, this.n) && this.energy < this.maxStorage)) {
            this.energy -= this.output - EnergyNet.getForWorld(this.k).emitEnergyFrom(this, this.output);
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(aji emitter, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(aji receiver, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energy < this.maxStorage;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.output) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.output) {
            need = this.maxStorage + this.output - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiElectricBlock";
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(og entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        EnergyNet.getForWorld(this.k).addTileEntity(this);
        this.addedToEnergyNet = true;
    }

    public boolean isEmittingRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.maxStorage;
            }
            case 2: {
                return this.energy > this.output && this.energy < this.maxStorage;
            }
            case 3: {
                return this.energy < this.output;
            }
        }
        return false;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side.flag) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public void onNetworkEvent(og player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        switch (this.redstoneMode) {
            case 0: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Nothing");
                break;
            }
            case 1: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if full");
                break;
            }
            case 2: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if partially filled");
                break;
            }
            case 3: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if empty");
                break;
            }
            case 4: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy");
                break;
            }
            case 5: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy unless full");
            }
        }
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }
}

