/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergySink;
import ic2.common.ContainerCropmatron;
import ic2.common.ContainerIC2;
import ic2.common.EnergyNet;
import ic2.common.IC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.TileEntityCrop;
import ic2.common.TileEntityMachine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityCropmatron
extends TileEntityMachine
implements IEnergySink,
IHasGui,
ISidedInventory {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 1000;
    public int scanX = -4;
    public int scanY = -1;
    public int scanZ = -4;
    public boolean addedToEnergyNet = false;
    public static int maxInput = 32;

    public TileEntityCropmatron() {
        super(9);
    }

    @Override
    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.d("energy");
    }

    @Override
    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", (short)this.energy);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void g() {
        super.g();
        if (this.energy >= 31) {
            this.scan();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    public void scan() {
        ++this.scanX;
        if (this.scanX > 4) {
            this.scanX = -4;
            ++this.scanZ;
            if (this.scanZ > 4) {
                this.scanZ = -4;
                ++this.scanY;
                if (this.scanY > 1) {
                    this.scanY = -1;
                }
            }
        }
        --this.energy;
        aji te = this.k.p(this.l + this.scanX, this.m + this.scanY, this.n + this.scanZ);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            this.updateSlots();
            if (this.inventory[0] != null && this.inventory[0].c == Ic2Items.fertilizer.c && crop.applyFertilizer(false)) {
                this.energy -= 10;
                --this.inventory[0].a;
                this.checkStackSizeZero(0);
            }
            if (this.inventory[3] != null && this.inventory[3].c == Ic2Items.hydratingCell.c && crop.applyHydration(false, this.inventory[3])) {
                this.energy -= 10;
                this.checkStackSizeZero(3);
            }
            if (this.inventory[6] != null && this.inventory[6].c == Ic2Items.weedEx.c && crop.applyWeedEx(false)) {
                this.energy -= 10;
                this.inventory[6].a(1, null);
                if (this.inventory[6].j() >= this.inventory[6].k()) {
                    --this.inventory[6].a;
                    this.checkStackSizeZero(6);
                }
            }
        }
    }

    public void checkStackSizeZero(int x) {
        if (this.inventory[x] != null && this.inventory[x].a <= 0) {
            this.inventory[x] = null;
        }
    }

    public void updateSlots() {
        this.moveFrom(1, 0);
        this.moveFrom(2, 1);
        this.moveFrom(4, 3);
        this.moveFrom(5, 4);
        this.moveFrom(7, 6);
        this.moveFrom(8, 7);
    }

    public void moveFrom(int from, int to) {
        if (this.inventory[from] != null && this.inventory[to] == null) {
            this.inventory[to] = this.inventory[from];
            this.inventory[from] = null;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(aji emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energy <= this.maxEnergy - maxInput;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / this.maxEnergy;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > maxInput) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        this.energy += amount;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public String b() {
        return "Crop-Matron";
    }

    @Override
    public String getGuiClassName(og entityPlayer) {
        return "GuiCropmatron";
    }

    @Override
    public ContainerIC2 getGuiContainer(og entityPlayer) {
        return new ContainerCropmatron(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(og entityPlayer) {
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 6;
            }
            case UP: {
                return 3;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 3;
    }
}

