/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.INetworkDataProvider;
import ic2.api.INetworkUpdateListener;
import ic2.api.IWrenchable;
import ic2.common.IC2;
import ic2.common.ITickCallback;
import java.util.List;
import java.util.Vector;

public class TileEntityBlock
extends aji
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;

    public void q() {
        super.q();
        if (!this.loaded) {
            if (!this.p() && this.k != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.k, new ITickCallback(){

                        @Override
                        public void tickCallback(up world) {
                            TileEntityBlock.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                System.out.println("[IC2] " + this + " (" + this.l + "," + this.m + "," + this.n + ") was not added, isInvalid=" + this.p() + ", worldObj=" + this.k);
            }
        }
    }

    public void j() {
        super.j();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (!IC2.platform.isSimulating()) {
            IC2.network.requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void a(an nbttagcompound) {
        super.a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.d("facing");
    }

    public void b(an nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            IC2.network.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int blockId = this.k.a(this.l, this.m, this.n);
            if (blockId < aig.m.length && aig.m[blockId] != null) {
                int side;
                aig block = aig.m[blockId];
                boolean newActive = this.active;
                short newFacing = this.facing;
                this.active = this.prevActive;
                this.facing = this.prevFacing;
                int[] textureIndex = new int[6];
                for (side = 0; side < 6; ++side) {
                    textureIndex[side] = IC2.platform.getBlockTexture(block, (uz)this.k, this.l, this.m, this.n, side);
                }
                this.active = newActive;
                this.facing = newFacing;
                for (side = 0; side < 6; ++side) {
                    int newTextureIndex = IC2.platform.getBlockTexture(block, (uz)this.k, this.l, this.m, this.n, side);
                    if (textureIndex[side] == newTextureIndex || IC2.textureIndex.get(blockId, textureIndex[side]) == IC2.textureIndex.get(blockId, newTextureIndex)) continue;
                    this.k.h(this.l, this.m, this.n);
                    break;
                }
            } else {
                System.out.println("[IC2] Invalid TE at " + this.l + "/" + this.m + "/" + this.n + ", no corresponding block");
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(og entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            IC2.network.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(og entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }
}

