/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
import ic2.common.TextureIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class TextureIndexClient
extends TextureIndex {
    private Map textureIndexes = new HashMap();

    @Override
    public int get(int blockId, int index) {
        String textureFile = aig.m[blockId].getTextureFile();
        if (!this.textureIndexes.containsKey(textureFile)) {
            int[] image = Minecraft.x().o.a(textureFile);
            int subtextureSize = (int)Math.sqrt(image.length) / 16;
            Vector values = new Vector(256);
            int compareIndex = 0;
            block0: for (int genIndex = 0; genIndex < 256; ++genIndex) {
                int imageBaseIndexA = genIndex / 16 * 16 * subtextureSize * subtextureSize + genIndex % 16 * subtextureSize;
                block1: for (int cmpIndex = 0; cmpIndex < genIndex; ++cmpIndex) {
                    int imageIndexA = imageBaseIndexA;
                    int imageIndexB = cmpIndex / 16 * 16 * subtextureSize * subtextureSize + cmpIndex % 16 * subtextureSize;
                    for (int y = 0; y < subtextureSize; ++y) {
                        for (int x = 0; x < subtextureSize; ++x) {
                            if (image[imageIndexA] != image[imageIndexB]) continue block1;
                            ++imageIndexA;
                            ++imageIndexB;
                        }
                        imageIndexA += 15 * subtextureSize;
                        imageIndexB += 15 * subtextureSize;
                    }
                    values.add(values.get(cmpIndex));
                    continue block0;
                }
                values.add(compareIndex);
                ++compareIndex;
            }
            this.textureIndexes.put(textureFile, values);
        }
        return (Integer)((List)this.textureIndexes.get(textureFile)).get(index);
    }

    @Override
    public void reset() {
        this.textureIndexes.clear();
    }
}

