/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IWrenchable;
import ic2.common.AudioManager;
import ic2.common.IC2;
import ic2.common.ItemIC2;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityTerra;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(int id, int index) {
        super(id, index);
        this.e(160);
        this.d(1);
    }

    public boolean canTakeDamage(rj stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(rj itemstack, og entityPlayer, up world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        int blockId = world.a(x, y, z);
        int metaData = world.g(x, y, z);
        aji tileEntity = world.p(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (IC2.keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.af()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (this.canTakeDamage(itemstack, 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (IC2.platform.isSimulating()) {
                    if (IC2.enableLoggingWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                        MinecraftServer.C();
                        MinecraftServer.a.log(Level.INFO, "Player " + entityPlayer.bJ + " used the wrench to remove the " + blockName + " (" + blockId + "-" + metaData + ") at " + x + "/" + y + "/" + z);
                    }
                    aig block = aig.m[blockId];
                    ArrayList drops = block.getBlockDropped(world, x, y, z, metaData, 0);
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canTakeDamage(itemstack, 200)) {
                            IC2.platform.messagePlayer(entityPlayer, "Not enough energy for lossless wrench operation");
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    } else {
                        dropOriginalBlock = world.v.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.damage(itemstack, 10, entityPlayer);
                    }
                    if (dropOriginalBlock) {
                        drops.set(0, new rj(blockId, 1, metaData));
                    }
                    for (rj itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.e(x, y, z, 0);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
        }
        return false;
    }

    public void damage(rj is, int damage, og player) {
        is.a(damage, (jw)player);
    }

    public boolean overrideWrenchSuccessRate(rj itemStack) {
        return false;
    }
}

