/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
import ic2.api.INetworkItemEventListener;
import ic2.common.AudioManager;
import ic2.common.ElectricItem;
import ic2.common.EntityMiningLaser;
import ic2.common.IC2;
import ic2.common.ItemElectricTool;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;

public class ItemToolMiningLaser
extends ItemElectricTool
implements INetworkItemEventListener {
    private static final int EventShotMining = 0;
    private static final int EventShotLowFocus = 1;
    private static final int EventShotLongRange = 2;
    private static final int EventShotHorizontal = 3;
    private static final int EventShotSuperHeat = 4;
    private static final int EventShotScatter = 5;
    private static final int EventShotExplosive = 6;

    public ItemToolMiningLaser(int id, int sprite) {
        super(id, sprite, ri.a, 100);
        this.maxCharge = 200000;
        this.transferLimit = 120;
        this.tier = 2;
    }

    public rj a(rj itemstack, up world, og entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemstack;
        }
        an nbtData = StackUtil.getOrCreateNbtData(itemstack);
        int laserSetting = nbtData.e("laserSetting");
        if (IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            laserSetting = (laserSetting + 1) % 7;
            nbtData.a("laserSetting", laserSetting);
            String laser = (new String[]{"Mining", "Low-Focus", "Long-Range", "Horizontal", "Super-Heat", "Scatter", "Explosive"})[laserSetting];
            IC2.platform.messagePlayer(entityplayer, "Laser Mode: " + laser);
        } else {
            int consume = (new int[]{1250, 100, 5000, 0, 2500, 10000, 5000})[laserSetting];
            if (!ElectricItem.use(itemstack, consume, entityplayer)) {
                return itemstack;
            }
            switch (laserSetting) {
                case 0: {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 0, true);
                    break;
                }
                case 1: {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, 4.0f, 5.0f, 1, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 1, true);
                    break;
                }
                case 2: {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, Float.POSITIVE_INFINITY, 20.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 2, true);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, Float.POSITIVE_INFINITY, 8.0f, Integer.MAX_VALUE, false, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 4, true);
                    break;
                }
                case 5: {
                    for (int x = -2; x <= 2; ++x) {
                        for (int y = -2; y <= 2; ++y) {
                            world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, false, entityplayer.z + 20.0f * (float)x, entityplayer.A + 20.0f * (float)y));
                        }
                    }
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 5, true);
                    break;
                }
                case 6: {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 6, true);
                }
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(rj itemstack, og entityPlayer, up world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        an nbtData = StackUtil.getOrCreateNbtData(itemstack);
        if (!IC2.keyboard.isModeSwitchKeyDown(entityPlayer) && nbtData.e("laserSetting") == 3) {
            if (Math.abs(entityPlayer.u + (double)entityPlayer.e() - 0.1 - ((double)y + 0.5)) < 1.5) {
                if (ElectricItem.use(itemstack, 3000, entityPlayer)) {
                    world.d((jn)new EntityMiningLaser(world, (jw)entityPlayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false, entityPlayer.z, 0.0, (double)y + 0.5));
                    IC2.network.initiateItemEvent(entityPlayer, itemstack, 3, true);
                }
            } else {
                IC2.platform.messagePlayer(entityPlayer, "Mining laser aiming angle too steep");
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public rt e(rj stack) {
        return rt.b;
    }

    @Override
    public void onNetworkEvent(int metaData, og player, int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 1: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLowFocus.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 2: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLongRange.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 3: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 4: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 5: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserScatter.ogg", true, AudioManager.defaultVolume);
                break;
            }
            case 6: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserExplosive.ogg", true, AudioManager.defaultVolume);
            }
        }
    }
}

