/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.AudioManager;
import ic2.common.ElectricItem;
import ic2.common.IC2;
import ic2.common.PositionSpec;
import ic2.common.Util;
import java.util.Map;

public class ItemScanner
extends ElectricItem {
    public ItemScanner(int id, int index, int t) {
        super(id, index);
        this.maxCharge = 10000;
        this.transferLimit = 50;
        this.tier = t;
    }

    public rj a(rj itemstack, up world, og entityplayer) {
        if (this.tier == 1 && !ElectricItem.use(itemstack, 50, entityplayer) || this.tier == 2 && !ElectricItem.use(itemstack, 250, entityplayer)) {
            return itemstack;
        }
        IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/ODScanner.ogg", true, AudioManager.defaultVolume);
        if (this.tier == 2) {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.t), Util.roundToNegInf(entityplayer.u), Util.roundToNegInf(entityplayer.v), true);
            IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore value in this area is " + value);
        } else {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.t), Util.roundToNegInf(entityplayer.u), Util.roundToNegInf(entityplayer.v), false);
            IC2.platform.messagePlayer(entityplayer, "SCAN RESULT: Ore density in this area is " + value);
        }
        return itemstack;
    }

    public static int valueOfArea(up worldObj, int x, int y, int z, boolean advancedMode) {
        int totalScore = 0;
        int blocksScanned = 0;
        int range = advancedMode ? 4 : 2;
        for (int blockY = y; blockY > 0; --blockY) {
            for (int blockX = x - range; blockX <= x + range; ++blockX) {
                for (int blockZ = z - range; blockZ <= z + range; ++blockZ) {
                    int blockId = worldObj.a(blockX, blockY, blockZ);
                    int metaData = worldObj.g(x, y, z);
                    if (advancedMode) {
                        totalScore += ItemScanner.valueOf(blockId, metaData);
                    } else if (ItemScanner.isValuable(blockId, metaData)) {
                        ++totalScore;
                    }
                    ++blocksScanned;
                }
            }
        }
        return blocksScanned > 0 ? Integer.valueOf((int)(1000.0 * (double)totalScore / (double)blocksScanned)) : null;
    }

    public static boolean isValuable(int blockId, int metaData) {
        return ItemScanner.valueOf(blockId, metaData) > 0;
    }

    public static int valueOf(int blockId, int metaData) {
        if (IC2.valuableOres.containsKey(blockId)) {
            Map metaMap = (Map)IC2.valuableOres.get(blockId);
            if (metaMap.containsKey(-1)) {
                return (Integer)metaMap.get(-1);
            }
            if (metaMap.containsKey(metaData)) {
                return (Integer)metaMap.get(metaData);
            }
        }
        return 0;
    }

    public int startLayerScan(rj itemStack) {
        return ElectricItem.use(itemStack, 50, null) ? 2 : 0;
    }
}

