/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.common.ItemIC2;

public class ItemReactorHeatpack
extends ItemIC2
implements IReactorComponent {
    public int maxPer;
    public int heatPer;

    public ItemReactorHeatpack(int id, int index, int maxper, int heatper) {
        super(id, index);
        this.maxPer = maxper;
        this.heatPer = heatper;
    }

    @Override
    public void processChamber(IReactor reactor, rj yourStack, int x, int y) {
        this.heat(reactor, yourStack.a, x + 1, y);
        this.heat(reactor, yourStack.a, x - 1, y);
        this.heat(reactor, yourStack.a, x, y + 1);
        this.heat(reactor, yourStack.a, x, y - 1);
    }

    private void heat(IReactor reactor, int stacksize, int x, int y) {
        IReactorComponent comp;
        int want = this.maxPer * stacksize;
        if (reactor.getHeat() >= want) {
            return;
        }
        rj stack = reactor.getItemAt(x, y);
        if (stack != null && stack.b() instanceof IReactorComponent && (comp = (IReactorComponent)stack.b()).canStoreHeat(reactor, stack, x, y)) {
            int add = this.heatPer * stacksize;
            int curr = comp.getCurrentHeat(reactor, stack, x, y);
            if (add > want - curr) {
                add = want - curr;
            }
            if (add > 0) {
                comp.alterHeat(reactor, stack, x, y, add);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, rj yourStack, rj pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, rj yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, rj yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, rj yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, rj yourStack, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(IReactor reactor, rj yourStack) {
        return yourStack.a / 10;
    }
}

