/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.common.ItemGradual;
import ic2.common.StackUtil;

public class ItemReactorHeatStorage
extends ItemGradual
implements IReactorComponent {
    public int heatStorage;

    public ItemReactorHeatStorage(int id, int index, int heatStorage) {
        super(id, index);
        this.heatStorage = heatStorage;
    }

    @Override
    public void processChamber(IReactor reactor, rj yourStack, int x, int y) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, rj yourStack, rj pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, rj yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, rj yourStack, int x, int y) {
        return this.heatStorage;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, rj yourStack, int x, int y) {
        return this.getHeatOfStack(yourStack);
    }

    @Override
    public int alterHeat(IReactor reactor, rj yourStack, int x, int y, int heat) {
        int myHeat = this.getHeatOfStack(yourStack);
        if ((myHeat += heat) > this.heatStorage) {
            reactor.setItemAt(x, y, null);
            heat = this.heatStorage - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setHeatForStack(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, rj yourStack) {
        return 0.0f;
    }

    private void setHeatForStack(rj stack, int heat) {
        an nbtData = StackUtil.getOrCreateNbtData(stack);
        nbtData.a("heat", heat);
        if (this.heatStorage > 0) {
            double p = (double)heat / (double)this.heatStorage;
            int newDmg = (int)((double)stack.k() * p);
            if (newDmg >= stack.k()) {
                newDmg = stack.k() - 1;
            }
            stack.b(newDmg);
        }
    }

    private int getHeatOfStack(rj stack) {
        an nbtData = StackUtil.getOrCreateNbtData(stack);
        return nbtData.e("heat");
    }
}

