/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.CropCard;
import ic2.api.TECrop;
import ic2.common.Ic2Items;

public class CropCoffee
extends CropCard {
    @Override
    public String name() {
        return "Coffee";
    }

    @Override
    public String discoveredBy() {
        return "Snoochy";
    }

    @Override
    public int tier() {
        return 7;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Leaves", "Ingrident", "Beans"};
    }

    @Override
    public int getSpriteIndex(TECrop crop) {
        if (crop.size == 5) {
            return 43;
        }
        if (crop.size == 4) {
            return 42;
        }
        return 31 + crop.size;
    }

    @Override
    public boolean canGrow(TECrop crop) {
        return crop.size < 5 && crop.getLightLevel() >= 9;
    }

    @Override
    public int weightInfluences(TECrop crop, float humidity, float nutrients, float air) {
        return (int)(0.4 * (double)humidity + 1.4 * (double)nutrients + 1.2 * (double)air);
    }

    @Override
    public int growthDuration(TECrop crop) {
        if (crop.size == 3) {
            return (int)((double)super.growthDuration(crop) * 0.5);
        }
        if (crop.size == 4) {
            return (int)((double)super.growthDuration(crop) * 1.5);
        }
        return super.growthDuration(crop);
    }

    @Override
    public boolean canBeHarvested(TECrop crop) {
        return crop.size >= 4;
    }

    @Override
    public rj getGain(TECrop crop) {
        if (crop.size == 4) {
            return null;
        }
        return new rj(Ic2Items.coffeeBeans.b());
    }

    @Override
    public byte getSizeAfterHarvest(TECrop crop) {
        return 3;
    }
}

