/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.Direction;
import ic2.api.IPaintableBlock;
import ic2.common.AabbUtil;
import ic2.common.BlockMultiID;
import ic2.common.IC2;
import ic2.common.Ic2Items;
import ic2.common.ItemBlockRare;
import ic2.common.ItemToolCutter;
import ic2.common.RenderBlockCable;
import ic2.common.StackUtil;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityCable;
import ic2.common.TileEntityCableDetector;
import ic2.common.TileEntityCableSplitter;
import java.util.ArrayList;
import java.util.List;

public class BlockCable
extends BlockMultiID
implements IPaintableBlock {
    public BlockCable(int i) {
        super(i, aco.f);
        this.c(0.2f);
        this.a(k);
        Ic2Items.copperCableBlock = new rj((aig)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new rj((aig)this, 1, 0);
        Ic2Items.goldCableBlock = new rj((aig)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new rj((aig)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new rj((aig)this, 1, 4);
        Ic2Items.ironCableBlock = new rj((aig)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new rj((aig)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new rj((aig)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new rj((aig)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new rj((aig)this, 1, 9);
        Ic2Items.tinCableBlock = new rj((aig)this, 1, 10);
        Ic2Items.detectorCableBlock = new rj((aig)this, 1, 11);
        Ic2Items.splitterCableBlock = new rj((aig)this, 1, 12);
        GameRegistry.registerBlock((aig)this, ItemBlockRare.class);
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_cable.png";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int b(uz iblockaccess, int x, int y, int z, int side) {
        short cableType;
        int color = 0;
        aji te = iblockaccess.p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            cableType = (short)iblockaccess.g(x, y, z);
            return cableType * 16 + color;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed != 0) {
            if (cable.foamed != 1) return 208 + cable.foamColor;
            return 178;
        }
        cableType = cable.cableType;
        if (!(te instanceof TileEntityCableDetector) && !(te instanceof TileEntityCableSplitter)) {
            color = cable.color;
            return cableType * 16 + color;
        }
        color = cable.getActive() ? 1 : 0;
        return cableType * 16 + color;
    }

    @Override
    public int a(int side, int meta) {
        return meta * 16;
    }

    public ajq a(up world, int x, int y, int z, ajs origin, ajs absDirection) {
        aji te = world.p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        ajs direction = ajs.a((double)(absDirection.a - origin.a), (double)(absDirection.b - origin.b), (double)(absDirection.c - origin.c));
        double maxLength = direction.c();
        double halfThickness = (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        ajs intersection = ajs.a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, ajn.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.d(origin) <= maxLength) {
            hit = true;
        }
        for (Direction dir : Direction.values()) {
            if (hit) break;
            aji target = dir.applyToTileEntity(tileEntityCable);
            if (!tileEntityCable.canInteractWith(target)) continue;
            ajn bbox = null;
            switch (dir) {
                case XN: {
                    bbox = ajn.a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case XP: {
                    bbox = ajn.a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YN: {
                    bbox = ajn.a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YP: {
                    bbox = ajn.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case ZN: {
                    bbox = ajn.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                    break;
                }
                case ZP: {
                    bbox = ajn.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                }
            }
            intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
            if (intersectingDirection == null || !(intersection.d(origin) <= maxLength)) continue;
            hit = true;
        }
        if (hit) {
            return new ajq(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public ajn getCollisionBoundingBoxFromPool(up world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return ajn.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public ajn e(up world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public ajn a_(up world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public ajn getCommonBoundingBoxFromPool(up world, int x, int y, int z, boolean selectionBoundingBox) {
        aji te = world.p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.p(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.p(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.p(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.p(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.p(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.p(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return ajn.a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(up world, int x, int y, int z) {
        aji te = world.p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean a(up world, int x, int y, int z, og entityPlayer, int side, float a, float b, float c) {
        rj cur = entityPlayer.bC();
        if (cur != null && cur.c == aig.E.ca) {
            if (!IC2.platform.isSimulating()) {
                return true;
            }
            aji te = world.p(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                    --cur.a;
                    if (cur.a <= 0) {
                        entityPlayer.by.a[entityPlayer.by.c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(uz iblockaccess, int i, int j2, int k) {
        aji te = iblockaccess.p(i, j2, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    @Override
    public boolean colorBlock(up world, int i, int j2, int k, int color) {
        return ((TileEntityCable)world.p(i, j2, k)).changeColor(color);
    }

    public boolean canHarvestBlock(og player, int md) {
        return true;
    }

    @Override
    public ArrayList getBlockDropped(up world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<rj> ret = new ArrayList<rj>();
        aji te = world.p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new rj(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        } else if (metadata != 13) {
            ret.add(new rj(Ic2Items.insulatedCopperCableItem.c, 1, metadata));
        }
        return ret;
    }

    @Override
    public void a(up world, int x, int y, int z, int a, int b) {
        aji te;
        if (world.g(x, y, z) == 13 && (te = world.p(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            StackUtil.dropAsEntity(world, x, y, z, new rj(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        }
    }

    @Override
    public TileEntityBlock createNewTileEntity(up world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public boolean c() {
        return false;
    }

    public int b() {
        return RenderBlockCable.renderId;
    }

    public boolean d() {
        return false;
    }

    public void a(up world, int i, int j2, int k, og entityplayer) {
        if (entityplayer.bC() != null && entityplayer.bC().b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.bC(), world, i, j2, k);
        }
    }

    public boolean a(uz iblockaccess, int x, int y, int z, int side) {
        aji te = iblockaccess.p(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive();
        }
        return false;
    }

    @Override
    public void a(int i, qg tabs, List itemList) {
    }

    public float m(up world, int x, int y, int z) {
        if (world.g(x, y, z) == 13) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getExplosionResistance(jn exploder, up world, int x, int y, int z, double src_x, double src_y, double src_z) {
        aji te = world.p(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(uz world, int X, int Y, int Z, int direction) {
        int meta = world.g(X, Y, Z);
        return meta == 11 || meta == 12;
    }

    @Override
    public rj getPickBlock(ajq target, up world, int x, int y, int z) {
        return new rj(Ic2Items.insulatedCopperCableItem.c, 1, world.g(x, y, z));
    }
}

