/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration32x.common;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import ic2.common.ElectricItem;
import ic2.common.ItemBatteryDischarged;
import ic2.common.StackUtil;
import ic2.common.TileEntityBaseGenerator;
import ic2.common.TileEntityElectricBlock;
import ic2.common.TileEntityElectricMachine;

public class TriggerCapacitor
extends Trigger {
    int action = 0;

    public TriggerCapacitor(int id, int action) {
        super(id);
        this.action = action;
    }

    public String getTextureFile() {
        return "/ic2/sprites/bctriggers.png";
    }

    public int getIndexInTexture() {
        switch (this.action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 18;
            }
            case 7: {
                return 21;
            }
            case 8: {
                return 19;
            }
            case 9: {
                return 20;
            }
        }
        return 0;
    }

    public String getDescription() {
        switch (this.action) {
            case 0: {
                return "Capacitor Empty";
            }
            case 1: {
                return "Capacitor Has Energy";
            }
            case 2: {
                return "Space For Energy";
            }
            case 3: {
                return "Capacitor Full";
            }
            case 4: {
                return "Charging Empty Item";
            }
            case 5: {
                return "Charging Partially Charged Item";
            }
            case 6: {
                return "Charging Fully Charged Item";
            }
            case 7: {
                return "Discharging Empty Item";
            }
            case 8: {
                return "Discharging Partially Charged Item";
            }
            case 9: {
                return "Discharging Fully Charged Item";
            }
        }
        return "This shouldn't happen";
    }

    public boolean isTriggerActive(aji tile, ITriggerParameter parameter) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityElectricMachine) {
            TileEntityElectricMachine teb = (TileEntityElectricMachine)tile;
            boolean hasEnergy = false;
            boolean hasRoom = false;
            boolean dischargeEnergy = false;
            boolean dischargeRoom = false;
            if (teb.energy > teb.maxInput) {
                hasEnergy = true;
            }
            if (teb.energy < teb.maxEnergy - teb.maxInput) {
                hasRoom = true;
            }
            if (teb.inventory[1] != null && teb.inventory[1].b() instanceof ElectricItem) {
                ElectricItem ei = (ElectricItem)teb.inventory[1].b();
                an nbt = StackUtil.getOrCreateNbtData(teb.inventory[1]);
                if (nbt.e("charge") > 0) {
                    dischargeEnergy = true;
                }
                if (nbt.e("charge") < ei.maxCharge) {
                    dischargeRoom = true;
                }
            } else if (teb.inventory[1] != null && teb.inventory[1].b() instanceof ItemBatteryDischarged) {
                dischargeEnergy = false;
                dischargeRoom = true;
            } else if (this.action == 7 || this.action == 8 || this.action == 9) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        } else if (tile instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator teb = (TileEntityBaseGenerator)tile;
            boolean hasEnergy = false;
            boolean hasRoom = false;
            boolean chargeEnergy = false;
            boolean chargeRoom = false;
            if (teb.storage > 0) {
                hasEnergy = true;
            }
            if (teb.storage < teb.maxStorage) {
                hasRoom = true;
            }
            if (teb.inventory[0] != null && teb.inventory[0].b() instanceof ElectricItem) {
                ElectricItem ei = (ElectricItem)teb.inventory[0].b();
                an nbt = StackUtil.getOrCreateNbtData(teb.inventory[0]);
                if (nbt.e("charge") > 0) {
                    chargeEnergy = true;
                }
                if (nbt.e("charge") < ei.maxCharge) {
                    chargeRoom = true;
                }
            } else if (teb.inventory[0] != null && teb.inventory[0].b() instanceof ItemBatteryDischarged) {
                chargeEnergy = false;
                chargeRoom = true;
            } else if (this.action == 4 || this.action == 5 || this.action == 6) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
            }
        } else if (tile instanceof TileEntityElectricBlock) {
            an nbt;
            ElectricItem ei;
            TileEntityElectricBlock teb = (TileEntityElectricBlock)tile;
            boolean hasEnergy = false;
            boolean hasRoom = false;
            boolean chargeEnergy = false;
            boolean chargeRoom = false;
            boolean dischargeEnergy = false;
            boolean dischargeRoom = false;
            if (teb.energy > teb.output) {
                hasEnergy = true;
            }
            if (teb.energy < teb.maxStorage) {
                hasRoom = true;
            }
            if (teb.inventory[0] != null && teb.inventory[0].b() instanceof ElectricItem) {
                ei = (ElectricItem)teb.inventory[0].b();
                nbt = StackUtil.getOrCreateNbtData(teb.inventory[0]);
                if (nbt.e("charge") > 0) {
                    chargeEnergy = true;
                }
                if (nbt.e("charge") < ei.maxCharge) {
                    chargeRoom = true;
                }
            } else if (teb.inventory[0] != null && teb.inventory[0].b() instanceof ItemBatteryDischarged) {
                chargeEnergy = false;
                chargeRoom = true;
            } else if (this.action == 4 || this.action == 5 || this.action == 6) {
                return false;
            }
            if (teb.inventory[1] != null && teb.inventory[1].b() instanceof ElectricItem) {
                ei = (ElectricItem)teb.inventory[1].b();
                nbt = StackUtil.getOrCreateNbtData(teb.inventory[1]);
                if (nbt.e("charge") > 0) {
                    dischargeEnergy = true;
                }
                if (nbt.e("charge") < ei.maxCharge) {
                    dischargeRoom = true;
                }
            } else if (teb.inventory[1] != null && teb.inventory[1].b() instanceof ItemBatteryDischarged) {
                dischargeEnergy = false;
                dischargeRoom = true;
            } else if (this.action == 7 || this.action == 8 || this.action == 9) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        }
        return false;
    }
}

