/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import ic2.api.IEnergySource;
import java.lang.reflect.Method;

public final class EnergyNet {
    Object energyNetInstance;
    private static Method EnergyNet_getForWorld;
    private static Method EnergyNet_addTileEntity;
    private static Method EnergyNet_removeTileEntity;
    private static Method EnergyNet_emitEnergyFrom;
    private static Method EnergyNet_getTotalEnergyConducted;

    public static EnergyNet getForWorld(up world) {
        try {
            if (EnergyNet_getForWorld == null) {
                EnergyNet_getForWorld = Class.forName(EnergyNet.getPackage() + ".common.EnergyNet").getMethod("getForWorld", up.class);
            }
            return new EnergyNet(EnergyNet_getForWorld.invoke(null, world));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EnergyNet(Object energyNetInstance) {
        this.energyNetInstance = energyNetInstance;
    }

    public void addTileEntity(aji addedTileEntity) {
        try {
            if (EnergyNet_addTileEntity == null) {
                EnergyNet_addTileEntity = Class.forName(EnergyNet.getPackage() + ".common.EnergyNet").getMethod("addTileEntity", aji.class);
            }
            EnergyNet_addTileEntity.invoke(this.energyNetInstance, addedTileEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeTileEntity(aji removedTileEntity) {
        try {
            if (EnergyNet_removeTileEntity == null) {
                EnergyNet_removeTileEntity = Class.forName(EnergyNet.getPackage() + ".common.EnergyNet").getMethod("removeTileEntity", aji.class);
            }
            EnergyNet_removeTileEntity.invoke(this.energyNetInstance, removedTileEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        try {
            if (EnergyNet_emitEnergyFrom == null) {
                EnergyNet_emitEnergyFrom = Class.forName(EnergyNet.getPackage() + ".common.EnergyNet").getMethod("emitEnergyFrom", IEnergySource.class, Integer.TYPE);
            }
            return (Integer)EnergyNet_emitEnergyFrom.invoke(this.energyNetInstance, energySource, amount);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalEnergyConducted(aji tileEntity) {
        try {
            if (EnergyNet_getTotalEnergyConducted == null) {
                EnergyNet_getTotalEnergyConducted = Class.forName(EnergyNet.getPackage() + ".common.EnergyNet").getMethod("getTotalEnergyConducted", aji.class);
            }
            return (Long)EnergyNet_getTotalEnergyConducted.invoke(this.energyNetInstance, tileEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getPackage() {
        Package pkg = EnergyNet.class.getPackage();
        if (pkg != null) {
            return pkg.getName().substring(0, pkg.getName().lastIndexOf(46));
        }
        return "ic2";
    }
}

