/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.PacketCustom;
import codechicken.core.ServerUtils;
import codechicken.enderstorage.ContainerEnderStorage;
import codechicken.enderstorage.EnderStorageServerPacketHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

public class EnderStorageManager {
    private static EnderStorageManager serverManager;
    private static EnderStorageManager clientManager;
    private File saveDir;
    private Map inventoryMap;
    private List inventories;
    private boolean client;

    public EnderStorageManager(boolean client, File saveDir) {
        this.client = client;
        this.saveDir = saveDir;
        this.inventoryMap = Collections.synchronizedMap(new HashMap());
        this.inventories = Collections.synchronizedList(new ArrayList());
    }

    public void sendOpenChestsTo(og player) {
        for (EnderStorageInv inv : this.inventories) {
            EnderStorageServerPacketHandler.sendOpenUpdateTo(player, inv.owner, inv.freq, inv.open > 0);
        }
    }

    public void save() {
        for (EnderStorageInv inv : this.inventories) {
            inv.save();
        }
    }

    public static void reloadManager(boolean client, File saveDir) {
        EnderStorageManager newManager = new EnderStorageManager(client, saveDir);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public File getSaveDir() {
        return this.saveDir;
    }

    public static EnderStorageManager instance(boolean client) {
        return client ? clientManager : serverManager;
    }

    public EnderStorageInv getStorage(String owner, int freq) {
        EnderStorageInv inv;
        Map<Integer, EnderStorageInv> invMap;
        if (owner == null) {
            owner = "global";
        }
        if ((invMap = (Map<Integer, EnderStorageInv>)this.inventoryMap.get(owner)) == null) {
            invMap = Collections.synchronizedMap(new HashMap());
            this.inventoryMap.put(owner, invMap);
        }
        if ((inv = (EnderStorageInv)invMap.get(freq)) == null) {
            inv = new EnderStorageInv(owner, freq);
            invMap.put(freq, inv);
            this.inventories.add(inv);
        }
        return inv;
    }

    public static int getFreqFromColours(int colour1, int colour2, int colour3) {
        return ((colour1 & 0xF) << 8) + ((colour2 & 0xF) << 4) + (colour3 & 0xF);
    }

    public static int getFreqFromColours(int[] colours) {
        return ((colours[0] & 0xF) << 8) + ((colours[1] & 0xF) << 4) + (colours[2] & 0xF);
    }

    public static int getColourFromFreq(int freq, int colour) {
        switch (colour) {
            case 0: {
                return freq >> 8 & 0xF;
            }
            case 1: {
                return freq >> 4 & 0xF;
            }
            case 2: {
                return freq & 0xF;
            }
        }
        return 0;
    }

    public static int[] getColoursFromFreq(int freq) {
        int[] ai = new int[]{freq >> 8 & 0xF, freq >> 4 & 0xF, freq & 0xF};
        return ai;
    }

    public boolean isChestOpen(String owner, int freq) {
        EnderStorageInv inv = this.getStorage(owner, freq);
        return inv != null && inv.getNumOpen() > 0;
    }

    public static void openChestGui(og player, final String owner, final int freq, final String name) {
        ServerUtils.openSMPContainer((gu)((gu)player), (ov)new ContainerEnderStorage((ix)player.by, owner, freq, false), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(gu player, int windowId) {
                PacketCustom packet = new PacketCustom("EnderStorage", 2);
                packet.writeByte(windowId);
                packet.writeString(owner);
                packet.writeShort(freq);
                packet.writeString(name);
                ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
            }
        });
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EnderStorageSaveHandler());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new EnderStoragePlayerTracker());
    }

    public class EnderStorageInv
    implements ix {
        int freq;
        String owner;
        rj[] items;
        File saveFile;
        DataOutputStream saveOut;
        FileOutputStream saveFileOut;
        ArrayList chests;
        int open;

        public EnderStorageInv(String owner, int freq) {
            this.freq = freq;
            this.owner = owner;
            this.empty();
            if (!EnderStorageManager.this.client) {
                this.loadItems();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadItems() {
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                this.saveFile = new File(EnderStorageManager.this.saveDir, String.valueOf(this.owner) + '/' + this.freq + ".dat");
                if (!this.saveFile.exists() || this.saveFile.length() == 0L) {
                    return;
                }
                try {
                    FileInputStream fin = new FileInputStream(this.saveFile);
                    DataInputStream datain = new DataInputStream(fin);
                    this.loadFromTagCompound((an)ay.b((DataInput)datain));
                    datain.close();
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void loadFromTagCompound(an compound) {
            this.items = new rj[this.i_()];
            at nbttaglist = compound.m("Items");
            int i = 0;
            while (i < nbttaglist.c()) {
                an nbttagcompound1 = (an)nbttaglist.b(i);
                int slot = nbttagcompound1.c("Slot") & 0xFF;
                if (slot >= 0 && slot < this.items.length) {
                    this.items[slot] = rj.a((an)nbttagcompound1);
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                try {
                    if (!this.saveFile.getParentFile().exists()) {
                        this.saveFile.getParentFile().mkdirs();
                    }
                    if (!this.saveFile.exists()) {
                        this.saveFile.createNewFile();
                    }
                    if (this.saveOut == null) {
                        this.saveFileOut = new FileOutputStream(this.saveFile);
                        this.saveOut = new DataOutputStream(new BufferedOutputStream(this.saveFileOut));
                    }
                    this.saveFileOut.getChannel().truncate(0L);
                    ay.a((ay)this.getSaveTagCompound(), (DataOutput)this.saveOut);
                    this.saveOut.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private an getSaveTagCompound() {
            at nbttaglist = new at();
            int slot = 0;
            while (slot < this.items.length) {
                if (this.items[slot] != null) {
                    an nbttagcompound1 = new an();
                    nbttagcompound1.a("Slot", (byte)slot);
                    this.items[slot].b(nbttagcompound1);
                    nbttaglist.a((ay)nbttagcompound1);
                }
                ++slot;
            }
            an compound = new an();
            compound.a("Items", (ay)nbttaglist);
            return compound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public rj a(int slot) {
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                return this.items[slot];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public rj b(int slot) {
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                rj stack = this.items[slot];
                this.items[slot] = null;
                this.save();
                return stack;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(int slot, rj stack) {
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                this.items[slot] = stack;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k_() {
            if (EnderStorageManager.this.client) {
                return;
            }
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                ++this.open;
                EnderStorageServerPacketHandler.sendOpenUpdateTo(null, this.owner, this.freq, this.open > 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void f() {
            if (EnderStorageManager.this.client) {
                return;
            }
            EnderStorageInv enderStorageInv = this;
            synchronized (enderStorageInv) {
                --this.open;
                EnderStorageServerPacketHandler.sendOpenUpdateTo(null, this.owner, this.freq, this.open > 0);
            }
        }

        public int getNumOpen() {
            return this.open;
        }

        public int i_() {
            return 9;
        }

        public rj a(int slot, int size) {
            rj item = this.a(slot);
            if (item != null) {
                if (item.a <= size) {
                    rj itemstack = item;
                    this.a(slot, null);
                    this.d();
                    return itemstack;
                }
                rj itemstack1 = item.a(size);
                if (item.a == 0) {
                    this.a(slot, null);
                }
                this.d();
                return itemstack1;
            }
            return null;
        }

        public String b() {
            return null;
        }

        public int j_() {
            return 64;
        }

        public void d() {
        }

        public boolean a(og var1) {
            return true;
        }

        public void empty() {
            this.items = new rj[this.i_()];
        }
    }

    public static class EnderStoragePlayerTracker
    implements IPlayerTracker {
        public void onPlayerLogin(og player) {
            EnderStorageManager.instance(false).sendOpenChestsTo(player);
        }

        public void onPlayerLogout(og player) {
        }

        public void onPlayerChangedDimension(og player) {
            EnderStorageManager.instance(false).sendOpenChestsTo(player);
        }

        public void onPlayerRespawn(og player) {
        }
    }

    public static class EnderStorageSaveHandler {
        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            EnderStorageManager manager = EnderStorageManager.instance(event.world.K);
            if (event.world.K) {
                EnderStorageManager.reloadManager(true, null);
            } else {
                File savedir = new File(CommonUtils.getWorldBaseSaveLocation((up)event.world), "EnderStorage");
                if (manager == null || !manager.getSaveDir().getAbsolutePath().equals(savedir.getAbsolutePath())) {
                    if (!savedir.exists()) {
                        savedir.mkdirs();
                    }
                    EnderStorageManager.reloadManager(false, savedir);
                }
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.world.K) {
                EnderStorageManager.instance(false).save();
            }
        }
    }
}

