/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage;

import codechicken.core.Quat;
import codechicken.core.Vector3;

public class EnderDyeButton {
    public int button;
    public Vector3[] verts;

    public EnderDyeButton(int index) {
        this.button = index;
        this.verts = new Vector3[8];
        this.verts[0] = new Vector3(0.0, -0.25, -0.0625);
        this.verts[1] = new Vector3(0.125, -0.25, -0.0625);
        this.verts[2] = new Vector3(0.125, -0.25, 0.0);
        this.verts[3] = new Vector3(0.0, -0.25, 0.0);
        this.verts[4] = new Vector3(0.0, 0.0, -0.0625);
        this.verts[5] = new Vector3(0.125, 0.0, -0.0625);
        this.verts[6] = new Vector3(0.125, 0.0, 0.0);
        this.verts[7] = new Vector3(0.0, 0.0, 0.0);
        int i = 0;
        while (i < 8) {
            this.verts[i].add(0.25 + 0.1875 * (double)index, -0.375, 0.9375);
            ++i;
        }
        Quat quat2 = Quat.aroundAxis((double)1.0, (double)0.0, (double)0.0, (double)-1.570795);
        int i2 = 0;
        while (i2 < 8) {
            quat2.rotate(this.verts[i2]);
            ++i2;
        }
    }

    private EnderDyeButton() {
    }

    public void rotateMeta(int angle) {
        this.rotate(0.5, 0.0, 0.5, 0.0, 1.0, 0.0, (double)angle * -0.5 * 3.14159);
    }

    public void rotate(double px, double py, double pz, double ax, double ay, double az, double angle) {
        Quat quat = Quat.aroundAxis((double)ax, (double)ay, (double)az, (double)angle);
        int i = 0;
        while (i < 8) {
            this.verts[i].add(-px, -py, -pz);
            quat.rotate(this.verts[i]);
            this.verts[i].add(px, py, pz);
            ++i;
        }
    }

    public EnderDyeButton copy() {
        EnderDyeButton newbutton = new EnderDyeButton();
        newbutton.button = this.button;
        newbutton.verts = new Vector3[8];
        int i = 0;
        while (i < 8) {
            newbutton.verts[i] = this.verts[i].copy();
            ++i;
        }
        return newbutton;
    }

    public void flipCoords(int ax, int ay, int az) {
        int i = 0;
        while (i < 8) {
            this.verts[i].add((double)ax, (double)ay, (double)az);
            ++i;
        }
    }

    public Vector3 getMin() {
        int minindex = 0;
        double mindist = 100.0;
        int i = 0;
        while (i < 8) {
            double dist = this.verts[i].x + this.verts[i].y + this.verts[i].z;
            if (dist < mindist) {
                mindist = dist;
                minindex = i;
            }
            ++i;
        }
        return this.verts[minindex];
    }

    public Vector3 getMax() {
        int maxindex = 0;
        double maxdist = 0.0;
        int i = 0;
        while (i < 8) {
            double dist = this.verts[i].x + this.verts[i].y + this.verts[i].z;
            if (dist > maxdist) {
                maxdist = dist;
                maxindex = i;
            }
            ++i;
        }
        return this.verts[maxindex];
    }
}

