/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final HashSet ingredientIDs = new HashSet();
    public static final HashSet apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(this, new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(this, new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(this, new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class getGuiClass() {
        return aqk.class;
    }

    @Override
    public String getRecipeName() {
        return "Brewing";
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (CachedBrewingRecipe recipe : apotions) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(rj result) {
        if (result.c != rh.bs.bT) {
            return;
        }
        int damage = result.j();
        for (CachedBrewingRecipe recipe : apotions) {
            if (recipe.result.item.j() != damage) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(rj ingredient) {
        if (ingredient.c != rh.bs.bT && !ingredientIDs.contains(ingredient.c)) {
            return;
        }
        for (CachedBrewingRecipe recipe : apotions) {
            if (!NEIClientUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIClientUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/alchemy.png";
    }

    public void drawForegrounda(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName("/gui/alchemy.png");
        int t = this.cycleticks % 120 / 4;
        gui.drawTexturedModalRect(92, 5, 176, 0, 8, t + 1);
        t = this.cycleticks % 35;
        gui.drawTexturedModalRect(60, 33 - t, 185, 31 - t, 12, t - 1);
    }

    @Override
    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(gui, 60, 1, 185, -2, 12, 30, 35, 3);
    }

    public void searchPotions() {
        HashSet newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> nextLevelPotions = new HashSet<Integer>();
        nextLevelPotions.add(0);
        do {
            newPotions = new HashSet();
            for (Integer basePotionID : nextLevelPotions) {
                if (rs.g((int)basePotionID)) continue;
                for (Integer ingredID : ingredientIDs) {
                    int result = sr.a((int)basePotionID, (String)rh.e[ingredID].t());
                    if (rs.g((int)result)) {
                        this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = rh.bs.f(basePotionID.intValue());
                    List newMods = rh.bs.f(result);
                    if (basePotionID > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotionID == result || this.levelModifierChanged(basePotionID, result)) continue;
                    this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                }
            }
        } while ((nextLevelPotions = newPotions).size() > 0);
        allPotions.add(0);
        API.setItemDamageVariants(rh.bs.bT, allPotions);
        API.addSetRange("Vanilla.Items.Potions", new MultiItemRange().add((rh)rh.bs));
        API.addSetRange("Vanilla.Items.Potions.Splash", new MultiItemRange().add((rh)rh.bs, 16384, 32768));
        MultiItemRange positivepots = new MultiItemRange();
        MultiItemRange negativepots = new MultiItemRange();
        MultiItemRange neutralpots = new MultiItemRange();
        Iterator iterator = allPotions.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            int potionID = (Integer)iterator.next();
            List effectlist = rh.bs.f(potionID);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty() && (iterator2 = effectlist.iterator()).hasNext()) {
                jj potioneffect = (jj)iterator2.next();
                type = ji.a[potioneffect.a()].f() ? -1 : 1;
            }
            if (type == 0) {
                neutralpots.add((rh)rh.bs, potionID, potionID);
                continue;
            }
            if (type == 1) {
                positivepots.add((rh)rh.bs, potionID, potionID);
                continue;
            }
            if (type != -1) continue;
            negativepots.add((rh)rh.bs, potionID, potionID);
        }
        API.addSetRange("Items.Potions.Positive", positivepots);
        API.addSetRange("Items.Potions.Negative", negativepots);
        API.addSetRange("Items.Potions.Neutral", neutralpots);
    }

    private boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private void addPotion(int ingred, int basePotion, int result, TreeSet allPotions, HashSet newPotions) {
        apotions.add(new CachedBrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int hashcode;
        PositionedStack precursorPotion;
        PositionedStack result;
        PositionedStack ingredient;

        public CachedBrewingRecipe(int ingredID, int basePotionID, int resultDamage) {
            super(BrewingRecipeHandler.this);
            this.precursorPotion = new PositionedStack(new rj(rh.bs.bT, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(new rj(ingredID, 1, 0), 74, 6);
            this.result = new PositionedStack(new rj(rh.bs.bT, 1, resultDamage), 97, 35);
            this.calculateHashcode();
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public ArrayList getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.ingredient);
            recipestacks.add(this.precursorPotion);
            return recipestacks;
        }

        private void calculateHashcode() {
            this.hashcode = this.result.item.j() << 16 + this.precursorPotion.item.j();
            this.hashcode = 31 * this.hashcode + (this.ingredient.item.c << 16 + this.ingredient.item.j());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBrewingRecipe)) {
                return false;
            }
            CachedBrewingRecipe recipe2 = (CachedBrewingRecipe)obj;
            return this.result.item.j() == recipe2.result.item.j() && this.precursorPotion.item.j() == recipe2.precursorPotion.item.j() && NEIClientUtils.areStacksSameType(this.ingredient.item, recipe2.ingredient.item);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

