/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.nei.EnchantmentInputHandler;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEICompatibility;
import codechicken.nei.api.API;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.weakDependancy_Forge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ItemInfo {
    public static final HashMap fallbackNames = new HashMap();
    public static final HashSet excludeIds = new HashSet();
    public static final HashSet nonUnlimitedIds = new HashSet();
    public static final HashMap damageVariants = new HashMap();
    public static final ArrayList defaultDamageRange = new ArrayList();
    public static final HashMap itemcompounds = new HashMap();
    public static final LinkedList infiniteHandlers = new LinkedList();

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList getItemDamageVariants(int itemID) {
        ArrayList damages = (ArrayList)damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemHash itemhash = new ItemHash(itemID, itemDamage);
        return (String)fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList getItemCompounds(int itemID) {
        return (ArrayList)itemcompounds.get(itemID);
    }

    public static void load() {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.addRecipeHandlers();
        ItemInfo.searchItems();
        ItemInfo.addMobSpawnerItem();
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new EnchantmentInputHandler());
    }

    private static void addRecipeHandlers() {
        API.registerRecipeHandler(new ShapedRecipeHandler());
        API.registerUsageHandler(new ShapedRecipeHandler());
        API.registerRecipeHandler(new ShapelessRecipeHandler());
        API.registerUsageHandler(new ShapelessRecipeHandler());
        API.registerRecipeHandler(new FurnaceRecipeHandler());
        API.registerUsageHandler(new FurnaceRecipeHandler());
        API.registerRecipeHandler(new BrewingRecipeHandler());
        API.registerUsageHandler(new BrewingRecipeHandler());
        API.registerRecipeHandler(new FuelRecipeHandler());
        API.registerUsageHandler(new FuelRecipeHandler());
        API.registerGuiOverlay(aqm.class, "crafting", 5, 11);
        API.registerGuiOverlay(aqu.class, "crafting2x2", 63, 20);
        API.registerGuiOverlay(aqt.class, "smelting", 5, 11);
        API.registerGuiOverlay(aqt.class, "fuel", 5, 11);
        API.registerGuiOverlay(aqk.class, "brewing", 5, 11);
    }

    private static void addMobSpawnerItem() {
        rh.e[aig.as.ca] = null;
        new ItemMobSpawner((up)NEIClientUtils.getMinecraft().e);
        if (NEICompatibility.hasForge) {
            weakDependancy_Forge.addMobSpawnerRenderer();
        }
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(aig.A.ca, 0, "Water Source");
        API.setMaxDamageException(aig.A.ca, 0);
        API.setOverrideName(aig.B.ca, 0, "Water Still");
        API.setMaxDamageException(aig.B.ca, 0);
        API.setOverrideName(aig.C.ca, 0, "Lava Source");
        API.setMaxDamageException(aig.C.ca, 0);
        API.setOverrideName(aig.D.ca, 0, "Lava Still");
        API.setMaxDamageException(aig.D.ca, 0);
        API.setOverrideName(aig.bl.ca, 0, "Silverfish Stone");
        API.setOverrideName(aig.bH.ca, 0, "End Portal");
        API.setOverrideName(aig.bI.ca, 0, "End Portal Frame");
        API.hideItem(aig.aa.ca);
        API.hideItem(aig.ac.ca);
        API.hideItem(aig.bt.ca);
        API.hideItem(aig.bs.ca);
        API.hideItem(aig.S.ca);
        API.hideItem(aig.av.ca);
        API.hideItem(aig.az.ca);
        API.hideItem(aig.aD.ca);
        API.hideItem(aig.aE.ca);
        API.hideItem(aig.aI.ca);
        API.hideItem(aig.aL.ca);
        API.hideItem(aig.aO.ca);
        API.hideItem(aig.aP.ca);
        API.hideItem(aig.aX.ca);
        API.hideItem(aig.bh.ca);
        API.hideItem(aig.bi.ca);
        API.hideItem(aig.bG.ca);
        API.hideItem(aig.bD.ca);
        API.hideItem(aig.bF.ca);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, an compound) {
                if (item < aig.m.length && aig.m[item] != null && aig.m[item].cp != aco.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, an compound) {
                if (item >= aig.m.length || aig.m[item] == null || aig.m[item].cp == aco.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Vanilla.Blocks", new MultiItemRange("[1-136]"));
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
        API.addSetRange("Vanilla.Items", new MultiItemRange("[256-388],[2256-2266]"));
    }

    private static void searchItems() {
        qg tab;
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[qg.a.length];
        qg[] qgArray = qg.a;
        int n = qg.a.length;
        int n2 = 0;
        while (n2 < n) {
            tab = qgArray[n2];
            creativeTabRanges[tab.a()] = new MultiItemRange();
            ++n2;
        }
        qgArray = rh.e;
        n = rh.e.length;
        n2 = 0;
        while (n2 < n) {
            qg item = qgArray[n2];
            if (item != null) {
                qg itemTab = item.w();
                if (itemTab != null) {
                    creativeTabRanges[itemTab.a()].add((rh)item);
                }
                if (item.m()) {
                    tools.add((rh)item);
                    if (item instanceof rq) {
                        picks.add((rh)item);
                    } else if (item instanceof sb) {
                        shovels.add((rh)item);
                    } else if (item instanceof rf) {
                        axes.add((rh)item);
                    } else if (item instanceof rg) {
                        hoes.add((rh)item);
                    } else if (item instanceof sn) {
                        swords.add((rh)item);
                    } else if (item instanceof pt) {
                        switch (((pt)item).a) {
                            case 0: {
                                helmets.add((rh)item);
                                break;
                            }
                            case 1: {
                                chest.add((rh)item);
                                break;
                            }
                            case 2: {
                                legs.add((rh)item);
                                break;
                            }
                            case 3: {
                                boots.add((rh)item);
                            }
                        }
                    } else if (item == rh.l || item == rh.k) {
                        ranged.add((rh)item);
                    } else if (item == rh.aR || item == rh.i || item == rh.be) {
                        other.add((rh)item);
                    }
                }
                if (item instanceof rd) {
                    food.add((rh)item);
                }
                if (item.u()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.bT);
                    potioningredients.add((rh)item);
                }
            }
            ++n2;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        qgArray = qg.a;
        n = qg.a.length;
        n2 = 0;
        while (n2 < n) {
            tab = qgArray[n2];
            if (creativeTabRanges[tab.a()].ranges.size() > 0) {
                API.addSetRange("CreativeTabs." + tab.c(), creativeTabRanges[tab.a()]);
            }
            ++n2;
        }
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)ModLoader.getPrivateValue(jr.class, null, (int)3);
            damages.add((Integer)classToIDMapping.get(mr.class));
            damages.add((Integer)classToIDMapping.get(nx.class));
            damages.add((Integer)classToIDMapping.get(no.class));
            damages.add((Integer)classToIDMapping.get(ny.class));
            damages.add((Integer)classToIDMapping.get(oa.class));
            damages.add((Integer)classToIDMapping.get(nz.class));
            damages.add((Integer)classToIDMapping.get(mo.class));
            damages.add((Integer)classToIDMapping.get(nn.class));
            damages.add((Integer)classToIDMapping.get(mp.class));
            damages.add((Integer)classToIDMapping.get(np.class));
            damages.add((Integer)classToIDMapping.get(mz.class));
            damages.add((Integer)classToIDMapping.get(nv.class));
            damages.add((Integer)classToIDMapping.get(mw.class));
            damages.add((Integer)classToIDMapping.get(nr.class));
            damages.add((Integer)classToIDMapping.get(nt.class));
            damages.add((Integer)classToIDMapping.get(mu.class));
            damages.add((Integer)classToIDMapping.get(nm.class));
            damages.add((Integer)classToIDMapping.get(od.class));
            damages.add((Integer)classToIDMapping.get(nw.class));
            damages.add((Integer)classToIDMapping.get(mt.class));
            damages.add((Integer)classToIDMapping.get(ms.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(mv.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(mx.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(rh.bC.bT, damages);
    }

    private static void addEntityEgg(ArrayList damages, Integer ID, int i, int j) {
        damages.add(ID);
        jr.a.put(ID, new js(ID.intValue(), i, j));
    }
}

