/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.PacketCustom;
import codechicken.core.ServerUtils;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemHash;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.common.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ServerPacketHandler
implements PacketCustom.ICustomPacketHandler.IServerPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, gz nethandler, gu sender) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.p, packet.readUnsignedByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((og)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.p, true);
                break;
            }
            case 10: {
                this.sendPermissableActionsTo(sender);
                this.sendBannedBlocksTo(sender);
                this.sendDisabledPropertiesTo(sender, sender.bK);
                ServerPacketHandler.sendMagnetModeTo(sender, NEIServerUtils.isMagnetMode(sender));
                ServerPacketHandler.sendCreativeModeTo(sender, NEIServerUtils.getCreativeMode(sender));
                break;
            }
            case 11: {
                sender.a(sender.bA, sender.bA.a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.toggleCreativeMode(sender);
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUnsignedByte(), packet.readUnsignedByte(), packet.readBoolean());
                break;
            }
            case 23: {
                this.processCreativeInv(sender, packet.readBoolean());
            }
        }
    }

    private void handlePropertyChange(gu sender, PacketCustom packet) {
        int id = packet.readUnsignedByte();
        if (NEIServerConfig.canPlayerUseFeature(sender.bJ, (String)AllowedPropertyMap.idToFeatureClassMap.get(id))) {
            this.handlePropertyChange(sender.bK, id, packet.readBoolean());
        }
    }

    private void processCreativeInv(gu sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer((gu)sender, (ov)new ContainerCreativeInv((og)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.bJ), Side.SERVER)), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(gu player, int windowId) {
                    PacketCustom packet = new PacketCustom(ServerPacketHandler.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
                }
            });
        } else {
            sender.l();
            PacketCustom packet = new PacketCustom(channel, 23);
            packet.writeBoolean(false);
            ServerUtils.sendPacketTo((og)sender, (db)packet.toPacket());
        }
    }

    private void handlePropertyChange(int dim, int propID, boolean disable) {
        NEIServerConfig.setPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(propID), disable);
        this.sendDisabledPropertiesTo(null, dim);
    }

    private void sendDisabledPropertiesTo(gu player, int dim) {
        ArrayList<Integer> disabledProperties = new ArrayList<Integer>();
        for (Map.Entry prop : AllowedPropertyMap.nameToIDMap.entrySet()) {
            if (!NEIServerConfig.isPropertyDisabled(dim, (String)prop.getKey())) continue;
            disabledProperties.add((Integer)prop.getValue());
        }
        PacketCustom packet = new PacketCustom(channel, 12);
        packet.writeByte(disabledProperties.size());
        Iterator iterator = disabledProperties.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        if (player != null) {
            ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
        } else {
            for (og sendplayer : ServerUtils.getPlayersInDimension((int)dim)) {
                ServerUtils.sendPacketTo((og)sendplayer, (db)packet.toPacket());
            }
        }
    }

    private void handleGiveItem(gu player, PacketCustom packet) {
        boolean infinite = packet.readBoolean();
        boolean doSpawn = packet.readBoolean();
        int num = packet.readUnsignedByte();
        LinkedList<String> name = new LinkedList<String>();
        int i = 0;
        while (i < num) {
            name.add(packet.readString());
            ++i;
        }
        rj item = packet.readItemStack();
        if (item == null) {
            ServerUtils.sendChatTo((gu)player, (String)"\u00a7fNo such item.");
            return;
        }
        item.a = packet.readInt();
        NEIServerUtils.givePlayerItem(player, item, infinite, name, doSpawn);
    }

    private void setInventorySlot(gu player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        rj item = packet.readItemStack();
        if (!NEIServerConfig.canPlayerUseFeature(player.bJ, item == null ? "delete" : "item")) {
            return;
        }
        NEIServerUtils.setSlotContents((og)player, slot, item, container);
    }

    private void modifyEnchantment(gu player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.bA;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(gu player) {
        ServerUtils.openSMPContainer((gu)player, (ov)new ContainerEnchantmentModifier(player.by, player.p, 0, 0, 0), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(gu player, int windowId) {
                PacketCustom packet = new PacketCustom(ServerPacketHandler.channel, 21);
                packet.writeByte(windowId);
                ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
            }
        });
    }

    public static void sendMagnetModeTo(gu player, boolean enable) {
        PacketCustom packet = new PacketCustom(channel, 6);
        packet.writeBoolean(enable);
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }

    public static void sendCreativeModeTo(gu player, int mode) {
        PacketCustom packet = new PacketCustom(channel, 7);
        packet.writeByte(mode);
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }

    private void sendPermissableActionsTo(gu player) {
        LinkedList<Integer> actions = new LinkedList<Integer>();
        InterActionMap[] interActionMapArray = InterActionMap.values();
        int n = interActionMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            InterActionMap action = interActionMapArray[n2];
            if (NEIServerConfig.canPlayerUseFeature(player.bJ, action.getName())) {
                actions.add(action.ordinal());
            }
            ++n2;
        }
        PacketCustom packet = new PacketCustom(channel, 10);
        packet.writeByte(actions.size());
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }

    private void sendBannedBlocksTo(gu player) {
        ArrayList<ItemHash> bannedblocks = new ArrayList<ItemHash>();
        for (Map.Entry entry : NEIServerConfig.bannedblocks.entrySet()) {
            if (NEIServerConfig.isPlayerInList(player.bJ, (HashSet)entry.getValue(), true)) continue;
            bannedblocks.add((ItemHash)entry.getKey());
        }
        PacketCustom packet = new PacketCustom(channel, 11);
        packet.writeInt(bannedblocks.size());
        for (ItemHash hash : bannedblocks) {
            packet.writeShort((int)hash.item);
            packet.writeShort((int)hash.damage);
        }
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }

    public static void sendHasServerSideTo(gu player) {
        System.out.println("Sending serverside check to: " + player.bJ);
        PacketCustom packet = new PacketCustom(channel, 1);
        packet.writeByte(4);
        packet.writeString(CommonUtils.getWorldName((up)player.p));
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }

    public static void sendAddMagneticItemTo(gu player, nj item) {
        PacketCustom packet = new PacketCustom(channel, 13);
        packet.writeInt(item.k);
        ServerUtils.sendPacketTo((og)player, (db)packet.toPacket());
    }
}

