/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ClientPacketHandler;
import codechicken.nei.ItemList;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.asm.NEIModContainer;
import codechicken.packager.Packager;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class NEIClientUtils
extends NEIServerUtils {
    private static Minecraft mc = NEIClientUtils.getMinecraft();

    public static Minecraft getMinecraft() {
        if (mc == null) {
            mc = ModLoader.getMinecraftInstance();
        }
        return mc;
    }

    public static void reportException(Exception exception) {
        try {
            exception.printStackTrace();
            String s = "nei " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File file = new File(Minecraft.b(), s);
            PrintWriter printwriter = new PrintWriter(new FileWriter(file));
            printwriter.print("[code]NEI Version: " + NEIModContainer.class.getAnnotation(Packager.class).getVersion() + "\n");
            exception.printStackTrace(printwriter);
            printwriter.println("[/code]");
            printwriter.close();
            NEIClientUtils.addChatMessage("Error written to " + s);
        }
        catch (Exception exception1) {
            System.out.println("Error during safeReportException:");
            exception1.printStackTrace();
        }
    }

    public static void addChatMessage(String s) {
        if (NEIClientUtils.mc.v != null) {
            NEIClientUtils.mc.v.b().a(s);
        }
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.getMinecraft().b.a(((aqh)NEIClientUtils.getMinecraft().r).d.c, -999, 0, false, (og)NEIClientUtils.getMinecraft().g);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        rj stack;
        rj rj2 = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc.g.bA.a(slotNumber).c();
        if (stack == null) {
            return;
        }
        if (stack.a == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.l();
            --stack.a;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        ClientPacketHandler.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(rj itemstack) {
        ov c = NEIClientUtils.getGuiContainer().d;
        int i = 0;
        while (i < c.b.size()) {
            rj itemstack1;
            pr slot = c.a(i);
            if (slot != null && (itemstack1 = slot.c()) != null && itemstack1.c == itemstack.c && itemstack1.j() == itemstack.j()) {
                NEIClientUtils.setSlotContents(i, null, true);
                slot.d(null);
            }
            ++i;
        }
    }

    public static rj getHeldItem() {
        return NEIClientUtils.mc.g.by.o();
    }

    public static void setSlotContents(int slot, rj item, boolean containerInv) {
        ClientPacketHandler.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc.g.by.b(item);
        }
    }

    public static void cheatItem(rj typeStack, int button, int mode) {
        if (!NEIClientConfig.isActionPermissable("item")) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                rj stack;
                if (!handler.canHandleItem(typeStack) || (stack = handler.getInfiniteItem(typeStack)) == null) continue;
                NEIClientUtils.giveStack(stack, stack.a, true);
                return;
            }
            NEIClientUtils.cheatItem(typeStack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(typeStack, 1);
        } else if (mode == 1 && typeStack.a < typeStack.d()) {
            NEIClientUtils.giveStack(typeStack, typeStack.d() - typeStack.a);
        } else {
            int amount = NEIClientConfig.getItemQuantity();
            if (amount == 0) {
                amount = typeStack.d();
            }
            NEIClientUtils.giveStack(typeStack, amount);
        }
    }

    public static void giveStack(rj itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.a);
    }

    public static void giveStack(rj itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    public static void giveStack(rj itemstack, int i, boolean infinite) {
        rj itemstack1 = NEIClientUtils.copyStack(itemstack, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            rj typestack = NEIClientUtils.copyStack(itemstack1, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((og)NEIClientUtils.mc.g, itemstack1) && NEIClientUtils.mc.r instanceof aqh) {
                aqh gui = NEIClientUtils.getGuiContainer();
                int increment = typestack.d();
                int given = 0;
                while (given < itemstack1.a) {
                    int qty = Math.min(itemstack1.a - given, increment);
                    int slotNo = -1;
                    for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                        slotNo = handler.getItemSpawnSlot(gui, typestack);
                        if (slotNo >= 0) break;
                    }
                    if (slotNo == -1) break;
                    pr slot = gui.d.a(slotNo);
                    int current = slot.d() ? slot.c().a : 0;
                    qty = Math.min(qty, slot.a() - current);
                    rj newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.d(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                    given += qty;
                }
                ClientPacketHandler.sendSpawnItem(NEIClientUtils.copyStack(typestack, given), infinite, false);
            } else {
                ClientPacketHandler.sendSpawnItem(itemstack1, infinite, true);
            }
        } else {
            int given = 0;
            while (given < itemstack1.a) {
                int qty = Math.min(itemstack1.a - given, itemstack1.d());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.give"), NEIClientUtils.mc.g.bJ, itemstack1.c, qty, itemstack1.j());
                given += qty;
            }
        }
    }

    public static void updateUnlimitedItems() {
        rj itemstack = NEIClientUtils.getHeldItem();
        if (itemstack != null && itemstack.a > 64) {
            itemstack.a = 1;
        }
        rj[] aitemstack = NEIClientUtils.mc.g.by.a;
        int slot = 0;
        while (slot < aitemstack.length) {
            rj itemstack1 = aitemstack[slot];
            if (itemstack1 != null) {
                if (itemstack1.a < 0 || itemstack1.a > 64) {
                    itemstack1.a = 111;
                }
                if (itemstack1.j() > -32000 && itemstack1.j() < -30000) {
                    itemstack1.b(-32000);
                }
            }
            ++slot;
        }
    }

    public static boolean isValidItem(rj test) {
        for (rj stack : ItemList.items) {
            if (!NEIClientUtils.areStacksIdentical(stack, test)) continue;
            return true;
        }
        return false;
    }

    public static boolean canItemFitInInventory(og player, rj itemstack) {
        int i = 0;
        while (i < player.by.i_() - 4) {
            if (player.by.a(i) == null) {
                return true;
            }
            ++i;
        }
        if (!itemstack.h()) {
            if (itemstack.d() == 1) {
                return false;
            }
            i = 0;
            while (i < player.by.i_()) {
                rj invstack = player.by.a(i);
                if (invstack != null && invstack.c == itemstack.c && invstack.e() && invstack.a < invstack.d() && invstack.a < player.by.j_() && (!invstack.g() || invstack.j() == itemstack.j())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getCreativeMode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc.b.h()) {
            return 1;
        }
        return 0;
    }

    public static void cycleCreativeMode() {
        int mode = NEIClientUtils.getCreativeMode();
        if (NEIClientConfig.hasSMPCounterPart()) {
            ClientPacketHandler.sendCycleCreativeMode();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), mode ^ 1, NEIClientUtils.mc.g.bJ);
        }
    }

    public static long getTime() {
        return NEIClientUtils.getMinecraft().e.H().f();
    }

    public static void setTime(long l) {
        NEIClientUtils.getMinecraft().e.H().b(l);
    }

    public static void setHourForward(int i) {
        long timethisday = NEIClientUtils.getTime() / 24000L * 24000L;
        long nexthour = timethisday + 24000L + (long)(i * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ClientPacketHandler.sendSetTime(i);
        } else {
            long l = NEIClientUtils.getTime() / 24000L * 24000L;
            long l1 = l + 24000L + (long)(i * 1000);
            NEIClientUtils.setTime(l1);
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), nexthour);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof Integer || args[i] instanceof Long) {
                messageformat.setFormatByArgumentIndex(i, numberformat);
            }
            ++i;
        }
        NEIClientUtils.mc.g.d(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.getMinecraft().e.H().o();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            ClientPacketHandler.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            ClientPacketHandler.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc.g.bJ);
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            ClientPacketHandler.sendToggleMagnetMode();
        }
    }

    public static ArrayList concatIntegersToRanges(List damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList addIntegersToRanges(List ranges, List damages) {
        for (int[] range : ranges) {
            int integer = range[0];
            while (integer <= range[1]) {
                damages.add(integer);
                ++integer;
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static void dumpIDs() {
        try {
            boolean blocks = NEIClientConfig.getBooleanSetting("ID dump.blockIDs");
            boolean items = NEIClientConfig.getBooleanSetting("ID dump.itemIDs");
            boolean unusedblocks = NEIClientConfig.getBooleanSetting("ID dump.unused blockIDs");
            boolean unuseditems = NEIClientConfig.getBooleanSetting("ID dump.unused itemIDs");
            String s = "IDMap dump " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File writeTo = new File(Minecraft.b(), s);
            if (!writeTo.exists()) {
                writeTo.createNewFile();
            }
            PrintWriter writer = new PrintWriter(writeTo);
            int i = 1;
            while (i < rh.e.length) {
                String name;
                if (i < aig.m.length && aig.m[i] != null) {
                    if (blocks) {
                        aig block = aig.m[i];
                        name = block.a();
                        if (name == null) {
                            name = block.getClass().getCanonicalName();
                        }
                        writer.println("Block. Name: " + name + ". ID: " + i);
                    }
                } else if (rh.e[i] != null) {
                    if (items) {
                        rh item = rh.e[i];
                        name = item.a();
                        if (name == null) {
                            name = item.getClass().getCanonicalName();
                        }
                        writer.println("Item. Name: " + name + ". ID: " + i);
                    }
                } else if (i < 256) {
                    if (unusedblocks) {
                        writer.println("Block. Unused ID: " + i);
                    }
                } else if (unuseditems) {
                    writer.println("Item. Unused ID: " + i);
                }
                ++i;
            }
            writer.close();
            NEIClientUtils.addChatMessage("Dumped IDMap to " + s);
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.setItemQuantity(i);
        LayoutManager.quantity.text = Integer.toString(i);
    }

    public static aqh getGuiContainer() {
        if (NEIClientUtils.mc.r instanceof aqh) {
            return (aqh)NEIClientUtils.mc.r;
        }
        return null;
    }

    public static void overlayScreen(apn gui) {
        NEIClientUtils.mc.r = null;
        mc.a(gui);
    }
}

