/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DropDownFile;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ItemVisibilityHash {
    private static boolean[] statesSaved = new boolean[7];
    public TreeMap hiddenitems;

    public ItemVisibilityHash() {
        try {
            this.loadFromCompound(this.getCurrentSaveCompound());
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public an getCurrentSaveCompound() {
        an hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
        an currentSave = hashSave.l("current");
        hashSave.a("current", currentSave);
        return currentSave;
    }

    public void hideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add((short)-1);
    }

    public void hideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add((short)damage);
    }

    public void hideItem(int item, an stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        if (!info.compounds.contains(stackTagCompound)) {
            info.compounds.add(stackTagCompound);
        }
    }

    public void hideItem(ItemHash item) {
        if (item.moreinfo != null) {
            this.hideItem((int)item.item, item.moreinfo);
        } else {
            this.hideItem((int)item.item, item.damage);
        }
    }

    public void unhideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        this.hiddenitems.remove(item);
    }

    public void unhideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        if (damage == -1) {
            this.hiddenitems.remove(item);
            return;
        }
        info.damages.remove((short)damage);
    }

    public void unhideItem(int item, an stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        info.compounds.remove(stackTagCompound);
    }

    public void unhideItem(ItemHash item) {
        if (item.moreinfo != null) {
            this.unhideItem((int)item.item, item.moreinfo);
        } else {
            this.unhideItem((int)item.item, item.damage);
        }
    }

    public boolean isItemHidden(int itemID, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)damage) || info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int itemID, an stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.compounds.contains(stackTagCompound);
    }

    public boolean isItemHidden(ItemHash item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item.item);
        if (info == null) {
            return false;
        }
        if (info.damages.contains(item.damage) || info.damages.contains((short)-1)) {
            return true;
        }
        if (item.moreinfo != null) {
            return info.compounds.contains(item.moreinfo);
        }
        return false;
    }

    private void loadFromCompound(an readTag) {
        this.hiddenitems = new TreeMap();
        for (Object obj : readTag.c()) {
            int i;
            IDInfo info;
            int itemID;
            if (obj instanceof at) {
                at compoundlist = (at)obj;
                itemID = Integer.parseInt(compoundlist.e().substring(1));
                info = (IDInfo)this.hiddenitems.get(itemID);
                if (info == null) {
                    info = new IDInfo();
                    this.hiddenitems.put(itemID, info);
                }
                i = 0;
                while (i < compoundlist.c()) {
                    info.compounds.add((an)compoundlist.b(i));
                    ++i;
                }
                continue;
            }
            if (!(obj instanceof al)) continue;
            al damagearray = (al)obj;
            itemID = Integer.parseInt(damagearray.e().substring(1));
            info = (IDInfo)this.hiddenitems.get(itemID);
            if (info == null) {
                info = new IDInfo();
                this.hiddenitems.put(itemID, info);
            }
            i = 0;
            while (i < damagearray.a.length / 2) {
                info.damages.add((short)((damagearray.a[i * 2] << 8) + damagearray.a[i * 2 + 1]));
                ++i;
            }
        }
    }

    public void save() {
        try {
            an hashSave = NEIClientConfig.saveCompound.l("vis");
            NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
            hashSave.a("current", this.constructSaveCompound());
            NEIClientConfig.saveConfig();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    private an constructSaveCompound() {
        an savecompound = new an();
        for (Map.Entry itemEntry : this.hiddenitems.entrySet()) {
            int id = (Integer)itemEntry.getKey();
            IDInfo info = (IDInfo)itemEntry.getValue();
            if (info.compounds.size() > 0) {
                at compoundlist = new at();
                for (an compound : info.compounds) {
                    compoundlist.a((ay)compound);
                }
                savecompound.a("c" + id, (ay)compoundlist);
            }
            if (info.damages.size() <= 0) continue;
            byte[] damagearray = new byte[info.damages.size() * 2];
            int i = 0;
            Iterator iterator = info.damages.iterator();
            while (iterator.hasNext()) {
                short damage = (Short)iterator.next();
                damagearray[i * 2] = (byte)(damage >> 8);
                damagearray[i * 2 + 1] = (byte)damage;
                ++i;
            }
            savecompound.a("d" + id, damagearray);
        }
        return savecompound;
    }

    public static void loadStates() {
        an hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
        int i = 0;
        while (i < 7) {
            an statesave = hashSave.l("save" + i);
            if (statesave.c().size() > 0) {
                ItemVisibilityHash.statesSaved[i] = true;
            }
            ++i;
        }
    }

    public void loadState(int i) {
        an hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
        this.loadFromCompound(hashSave.l("save" + i));
        DropDownFile.dropDownInstance.updateState();
        ItemList.updateSearch();
        NEIClientConfig.vishash.save();
    }

    public void saveState(int i) {
        an hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
        an saveCompound = this.getCurrentSaveCompound();
        saveCompound.a("saved", true);
        hashSave.a("save" + i, saveCompound);
        ItemVisibilityHash.statesSaved[i] = true;
        NEIClientConfig.saveConfig();
    }

    public void clearState(int i) {
        an hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (ay)hashSave);
        hashSave.a("save" + i, new an("save" + i));
        ItemVisibilityHash.statesSaved[i] = false;
        NEIClientConfig.saveConfig();
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static class IDInfo {
        public TreeSet damages = new TreeSet();
        public ArrayList compounds = new ArrayList();
    }
}

